/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMAckRequested;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMAckRequestedSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMAckRequestedSerializer();

    private RMAckRequestedSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    @Override
    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMAckRequested o = (RMAckRequested)object;
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            RMConstants wsrmConstants = provider.getConstants();
            QName ackRequestedQName = wsrmConstants.getAckRequestedQName();
            SOAPElement ackRequestedElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapHeader, ackRequestedQName, "soap header");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(ackRequestedElement, identifierQName, ackRequestedQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
            QName messageNumberQName = wsrmConstants.getMessageNumberQName();
            SOAPElement messageNumberElement = RMSerializationHelper.getOptionalElement(ackRequestedElement, messageNumberQName, ackRequestedQName);
            if (messageNumberElement != null) {
                String messageNumberString = RMSerializationHelper.getRequiredTextContent(messageNumberElement, messageNumberQName);
                long messageNumberValue = RMSerializationHelper.stringToLong(messageNumberString, "Unable to parse MessageNumber element text content");
                o.setMessageNumber(messageNumberValue);
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    @Override
    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMAckRequested o = (RMAckRequested)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName ackRequestedQName = wsrmConstants.getAckRequestedQName();
            SOAPElement ackRequestedElement = soapEnvelope.getHeader().addChildElement(ackRequestedQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            ackRequestedElement.addChildElement(identifierQName).setValue(o.getIdentifier());
            if (o.getMessageNumber() != 0L) {
                QName messageNumberQName = wsrmConstants.getMessageNumberQName();
                SOAPElement messageNumberElement = ackRequestedElement.addChildElement(messageNumberQName);
                messageNumberElement.setValue(String.valueOf(o.getMessageNumber()));
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

