/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.util.DOMPolicyReader;
import org.apache.ws.policy.util.PolicyFactory;
import org.apache.ws.policy.util.PolicyRegistry;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.policy.PolicyScopeLevel;
import org.jboss.ws.extensions.policy.annotation.Policy;
import org.jboss.ws.extensions.policy.annotation.PolicyAttachment;
import org.jboss.ws.extensions.policy.deployer.PolicyDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedPolicy;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaExtension;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLProperty;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class PolicyMetaDataBuilder {
    private static final Logger log = Logger.getLogger(PolicyMetaDataBuilder.class);
    private boolean serverSide = true;
    private boolean toolMode = false;
    private PolicyDeployer customDeployer;

    public PolicyMetaDataBuilder() {
    }

    public PolicyMetaDataBuilder(PolicyDeployer customDeployer) {
        this.customDeployer = customDeployer;
    }

    public static PolicyMetaDataBuilder getServerSidePolicyMetaDataBuilder(boolean toolMode) {
        PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
        builder.setServerSide(true);
        builder.setToolMode(toolMode);
        return builder;
    }

    public static PolicyMetaDataBuilder getClientSidePolicyMetaDataBuilder() {
        PolicyMetaDataBuilder builder = new PolicyMetaDataBuilder();
        builder.setServerSide(false);
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPolicyAnnotations(EndpointMetaData epMetaData, Class<?> sepClass) throws IOException {
        UnifiedVirtualFile vfRoot = epMetaData.getServiceMetaData().getUnifiedMetaData().getRootFile();
        for (Policy anPolicy : sepClass.getAnnotation(PolicyAttachment.class).value()) {
            InputStream is = null;
            try {
                String policyFileLocation = anPolicy.policyFileLocation();
                if (policyFileLocation.length() == 0) {
                    throw new IllegalStateException("Cannot obtain @Policy.policyFileLocation");
                }
                UnifiedVirtualFile vfPolicyFile = vfRoot.findChild(policyFileLocation);
                is = vfPolicyFile.toURL().openStream();
                DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
                org.apache.ws.policy.Policy unnormalizedPolicy = reader.readPolicy(is);
                org.apache.ws.policy.Policy normPolicy = (org.apache.ws.policy.Policy)unnormalizedPolicy.normalize();
                log.info((Object)("Deploying Annotated Policy = " + policyFileLocation));
                PolicyScopeLevel scope = anPolicy.scope();
                if (PolicyScopeLevel.WSDL_PORT.equals((Object)scope) || PolicyScopeLevel.WSDL_PORT_TYPE.equals((Object)scope) || PolicyScopeLevel.WSDL_BINDING.equals((Object)scope)) {
                    this.deployPolicy(normPolicy, scope, epMetaData);
                    continue;
                }
                throw new WSException("Policy scope " + (Object)((Object)scope) + " not supported yet!");
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void processPolicyExtensions(EndpointMetaData endpointMD, WSDLDefinitions wsdlDefinitions) {
        DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
        PolicyRegistry localPolicyRegistry = new PolicyRegistry();
        for (WSDLExtensibilityElement policyElement : wsdlDefinitions.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy")) {
            org.apache.ws.policy.Policy policy = reader.readPolicy(policyElement.getElement());
            localPolicyRegistry.register(policy.getPolicyURI(), policy);
        }
        WSDLService wsdlService = wsdlDefinitions.getService(endpointMD.getServiceMetaData().getServiceName());
        if (wsdlService != null) {
            WSDLEndpoint wsdlEndpoint = wsdlService.getEndpoint(endpointMD.getPortName());
            if (wsdlEndpoint != null) {
                List<WSDLExtensibilityElement> portPolicies = wsdlEndpoint.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy");
                this.processPolicies(portPolicies, PolicyScopeLevel.WSDL_PORT, endpointMD);
                List<WSDLExtensibilityElement> portPolicyReferences = wsdlEndpoint.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
                this.processPolicyReferences(portPolicyReferences, PolicyScopeLevel.WSDL_PORT, localPolicyRegistry, endpointMD);
            } else {
                log.warn((Object)("Cannot get port '" + endpointMD.getPortName() + "' from the given wsdl definitions! Eventual policies attached to this port won't be considered."));
            }
        } else {
            log.warn((Object)("Cannot get service '" + endpointMD.getServiceMetaData().getServiceName() + "' from the given wsdl definitions!  Eventual policies attached to this service won't be considered."));
        }
        WSDLBinding wsdlBinding = wsdlDefinitions.getBindingByInterfaceName(endpointMD.getPortTypeName());
        if (wsdlBinding != null) {
            List<WSDLExtensibilityElement> bindingPolicies = wsdlBinding.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy");
            this.processPolicies(bindingPolicies, PolicyScopeLevel.WSDL_BINDING, endpointMD);
            List<WSDLExtensibilityElement> bindingPolicyReferences = wsdlBinding.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policyReference");
            this.processPolicyReferences(bindingPolicyReferences, PolicyScopeLevel.WSDL_BINDING, localPolicyRegistry, endpointMD);
        } else {
            log.warn((Object)("Cannot get binding for portType '" + endpointMD.getPortTypeName() + "' from the given wsdl definitions!  Eventual policies attached to this binding won't be considered."));
        }
        WSDLInterface wsdlInterface = wsdlDefinitions.getInterface(endpointMD.getPortTypeName());
        if (wsdlInterface != null) {
            List<WSDLExtensibilityElement> portTypePolicies = wsdlInterface.getExtensibilityElements("http://www.jboss.org/jbossws/wsp/policy");
            this.processPolicies(portTypePolicies, PolicyScopeLevel.WSDL_PORT_TYPE, endpointMD);
            WSDLProperty portTypePolicyReferences = wsdlInterface.getProperty("http://www.jboss.org/jbossws/wsp/policyURIs");
            this.processPolicies(portTypePolicyReferences, PolicyScopeLevel.WSDL_PORT_TYPE, localPolicyRegistry, endpointMD);
        } else {
            log.warn((Object)("Cannot get portType '" + endpointMD.getPortTypeName() + "' from the given wsdl definitions! Eventual policies attached to this portType won't be considered."));
        }
    }

    private void processPolicies(WSDLProperty policyProp, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData) {
        if (policyProp != null && policyProp.getValue() != null) {
            StringTokenizer st = new StringTokenizer(policyProp.getValue(), ", ", false);
            while (st.hasMoreTokens()) {
                PolicyReference policyRef = new PolicyReference(st.nextToken());
                this.deployPolicy(this.resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
            }
        }
    }

    private void processPolicies(List<WSDLExtensibilityElement> policies, PolicyScopeLevel scope, ExtensibleMetaData extMetaData) {
        if (policies != null && policies.size() != 0) {
            DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
            for (WSDLExtensibilityElement policyElement : policies) {
                org.apache.ws.policy.Policy policy = reader.readPolicy(policyElement.getElement());
                this.deployPolicy(policy, scope, extMetaData);
            }
        }
    }

    private void processPolicyReferences(List<WSDLExtensibilityElement> policyReferences, PolicyScopeLevel scope, PolicyRegistry localPolicies, ExtensibleMetaData extMetaData) {
        if (policyReferences != null && policyReferences.size() != 0) {
            DOMPolicyReader reader = (DOMPolicyReader)PolicyFactory.getPolicyReader((int)3);
            for (WSDLExtensibilityElement element : policyReferences) {
                PolicyReference policyRef = reader.readPolicyReference(element.getElement());
                this.deployPolicy(this.resolvePolicyReference(policyRef, localPolicies), scope, extMetaData);
            }
        }
    }

    private org.apache.ws.policy.Policy resolvePolicyReference(PolicyReference policyRef, PolicyRegistry localPolicies) {
        org.apache.ws.policy.Policy normPolicy;
        try {
            normPolicy = (org.apache.ws.policy.Policy)policyRef.normalize(localPolicies);
        }
        catch (RuntimeException e) {
            normPolicy = null;
        }
        return normPolicy;
    }

    private void deployPolicy(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData) {
        PolicyDeployer deployer = this.customDeployer != null ? this.customDeployer : (this.toolMode ? PolicyDeployer.newInstanceForTools() : PolicyDeployer.getInstance());
        if (this.serverSide) {
            this.deployPolicyServerSide(policy, scope, extMetaData, deployer);
        } else {
            this.deployPolicyClientSide(policy, scope, extMetaData, deployer);
        }
    }

    private void deployPolicyServerSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer) {
        PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext == null) {
            ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
            extMetaData.addExtension(ext);
        }
        try {
            org.apache.ws.policy.Policy deployedPolicy = deployer.deployServerside(policy, extMetaData);
            ext.addPolicy(scope, deployedPolicy);
        }
        catch (UnsupportedPolicy e) {
            log.warn((Object)("Policy Not supported:" + policy.getPolicyURI()));
        }
    }

    private void deployPolicyClientSide(org.apache.ws.policy.Policy policy, PolicyScopeLevel scope, ExtensibleMetaData extMetaData, PolicyDeployer deployer) {
        PolicyMetaExtension ext = (PolicyMetaExtension)extMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
        if (ext == null) {
            ext = new PolicyMetaExtension("http://schemas.xmlsoap.org/ws/2004/09/policy");
            extMetaData.addExtension(ext);
        }
        try {
            deployer.deployClientSide(policy, extMetaData);
            ext.addPolicy(scope, policy);
        }
        catch (UnsupportedPolicy e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Policy Not supported:" + policy.getPolicyURI()));
            }
            WSException.rethrow("Policy not supported! " + policy.getPolicyURI(), e);
        }
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isToolMode() {
        return this.toolMode;
    }

    public void setToolMode(boolean toolMode) {
        this.toolMode = toolMode;
    }
}

