/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.vdf.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.vfs3.ArchiveFileSystem;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArchiveDeployment
implements VFSDeployment {
    private static final long serialVersionUID = 1L;
    private final Archive<?> archive;
    private final Deployment deployment;
    private final Closeable handle;
    private final VirtualFile file;

    ArchiveDeployment(Archive<?> archive, TempFileProvider tempFileProvider) {
        VirtualFile virtualFile;
        TempDir tempDir;
        assert (archive != null) : "archive must be specified";
        assert (tempFileProvider != null) : "provider must be specified";
        String archiveName = archive.getName();
        try {
            tempDir = tempFileProvider.createTempDir(archiveName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not create temp directory to back " + archive.toString(), ioe);
        }
        this.file = virtualFile = VFS.getChild((String)UUID.randomUUID().toString()).getChild(archiveName);
        this.archive = archive;
        try {
            this.handle = VFS.mount((VirtualFile)virtualFile, (FileSystem)new ArchiveFileSystem(archive, tempDir));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not mount for deployment: " + archive.toString(), ioe);
        }
        this.deployment = VFSDeploymentFactory.getInstance().createVFSDeployment(virtualFile);
    }

    Archive<?> getArchive() {
        return this.archive;
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    Closeable getHandle() {
        return this.handle;
    }

    public String getSimpleName() {
        return this.getDeployment().getSimpleName();
    }

    public String getName() {
        return this.getDeployment().getName();
    }

    public Set<String> getTypes() {
        return this.getDeployment().getTypes();
    }

    public void setTypes(Set<String> types) {
        this.getDeployment().setTypes(types);
    }

    public Attachments getPredeterminedManagedObjects() {
        return this.getDeployment().getPredeterminedManagedObjects();
    }

    public void setPredeterminedManagedObjects(Attachments predetermined) {
        this.getDeployment().setPredeterminedManagedObjects(predetermined);
    }

    public VirtualFile getRoot() {
        return this.file;
    }

    public String toString() {
        return "ArchiveDeployment [archive=" + this.archive + ", " + VirtualFile.class.getSimpleName() + "=" + this.file.toString() + "]";
    }
}

