/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.context.base;

import java.lang.reflect.Method;
import java.security.Identity;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import org.jboss.ejb3.context.base.Primitives;
import org.jboss.ejb3.context.spi.BeanManager;
import org.jboss.ejb3.context.spi.EJBContext;
import org.jboss.ejb3.context.spi.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInvocationContext
implements InvocationContext {
    private Map<String, Object> contextData = new HashMap<String, Object>();
    private Method method;
    private Object[] parameters;
    private EJBContext instanceContext;
    private Principal callerPrincipal;
    private Timer timer;

    public BaseInvocationContext(Method method, Object[] parameters) {
        this.method = method;
        this.parameters = parameters;
    }

    public Identity getCallerIdentity() {
        throw new UnsupportedOperationException("getCallerIdentity is deprecated");
    }

    public Principal getCallerPrincipal() {
        if (this.callerPrincipal == null) {
            throw new IllegalStateException("No callerPrincipal set on " + this);
        }
        return this.callerPrincipal;
    }

    public Map<String, Object> getContextData() {
        return this.contextData;
    }

    public EJBContext getEJBContext() {
        if (this.instanceContext == null) {
            throw new IllegalStateException("No instance associated with invocation " + this);
        }
        return this.instanceContext;
    }

    public EJBHome getEJBHome() {
        return this.getManager().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.getManager().getEJBLocalHome();
    }

    public Properties getEnvironment() {
        throw new UnsupportedOperationException("getEnvironment is deprecated");
    }

    public BeanManager getManager() {
        return this.getEJBContext().getManager();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        if (this.method == null) {
            throw new IllegalStateException("Getting parameters is not allowed on lifecycle callbacks (EJB 3.0 FR 12)");
        }
        return this.parameters;
    }

    public boolean getRollbackOnly() {
        return this.getManager().getRollbackOnly();
    }

    public Object getTarget() {
        return this.getEJBContext().getTarget();
    }

    public Object getTimer() {
        return this.timer;
    }

    public TimerService getTimerService() {
        return this.getManager().getTimerService();
    }

    public UserTransaction getUserTransaction() {
        return this.getManager().getUserTransaction();
    }

    public boolean isCallerInRole(Identity role) {
        throw new IllegalStateException("deprecated");
    }

    public boolean isCallerInRole(String roleName) {
        return this.getManager().isCallerInRole(this.getCallerPrincipal(), roleName);
    }

    public Object lookup(String name) throws IllegalArgumentException {
        return this.getManager().lookup(name);
    }

    public abstract Object proceed() throws Exception;

    public void setCallerPrincipal(Principal callerPrincipal) {
        this.callerPrincipal = callerPrincipal;
    }

    public void setEJBContext(EJBContext instanceContext) {
        this.instanceContext = instanceContext;
    }

    protected void setMethod(Method method) {
        this.method = method;
    }

    public void setParameters(Object[] params) throws IllegalArgumentException, IllegalStateException {
        if (this.method == null) {
            throw new IllegalStateException("Setting parameters is not allowed on lifecycle callbacks (EJB 3.0 FR 12)");
        }
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (params != null) {
            if (parameterTypes.length != params.length) {
                throw new IllegalArgumentException("Got wrong number of arguments, expected " + parameterTypes.length + ", got " + params.length + " on " + this.method);
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> actualType;
                Class<?> expectedType = Primitives.normalize(parameterTypes[i]);
                Object param = params[i];
                if (param == null || expectedType.isAssignableFrom(actualType = param.getClass())) continue;
                throw new IllegalArgumentException("Parameter " + i + " has the wrong type, expected " + expectedType + ", got " + actualType + " on " + this.method);
            }
        } else if (parameterTypes.length != 0) {
            throw new IllegalArgumentException("Got wrong number of arguments, expected " + parameterTypes.length + ", got none on " + this.method);
        }
        this.parameters = params;
    }

    public void setRollbackOnly() {
        this.getManager().setRollbackOnly();
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }
}

