/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;

public abstract class ConfigurationMaskingUtility {
    private static final String MASKED_PROPERTY_VALUE = "___MASKED___";

    public static void maskConfiguration(@NotNull Configuration configuration, @NotNull ConfigurationDefinition configurationDefinition) {
        if (configurationDefinition == null) {
            return;
        }
        Map childPropertyDefinitions = configurationDefinition.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.maskProperty(childPropertyDefinition, (AbstractPropertyMap)configuration);
        }
    }

    public static void unmaskConfiguration(@NotNull Configuration configuration, @NotNull ConfigurationDefinition configurationDefinition) {
        if (configurationDefinition == null) {
            return;
        }
        Map childPropertyDefinitions = configurationDefinition.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.unmaskProperty(childPropertyDefinition, (AbstractPropertyMap)configuration);
        }
    }

    private static void maskProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap) {
        PropertyDefinitionList propertyDefinitionList;
        PropertyDefinition listMemberPropertyDefinition;
        if (parentPropertyMap.get(propertyDefinition.getName()) == null) {
            return;
        }
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)propertyDefinition;
            if (propertyDefinitionSimple.getType() == PropertySimpleType.PASSWORD) {
                PropertySimple propertySimple = parentPropertyMap.getSimple(propertyDefinition.getName());
                if (propertySimple.getStringValue() == null) {
                    return;
                }
                if (MASKED_PROPERTY_VALUE.equals(propertySimple.getStringValue())) {
                    throw new IllegalStateException("maskConfiguration() was called more than once on the same Configuration.");
                }
                propertySimple.setUnmaskedStringValue(propertySimple.getStringValue());
                propertySimple.setStringValue(MASKED_PROPERTY_VALUE);
            }
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            PropertyMap propertyMap = parentPropertyMap.getMap(propertyDefinition.getName());
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
            ConfigurationMaskingUtility.maskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
        } else if (propertyDefinition instanceof PropertyDefinitionList && (listMemberPropertyDefinition = (propertyDefinitionList = (PropertyDefinitionList)propertyDefinition).getMemberDefinition()) instanceof PropertyDefinitionMap) {
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
            PropertyList propertyList = parentPropertyMap.getList(propertyDefinition.getName());
            for (Property property : propertyList.getList()) {
                PropertyMap propertyMap = (PropertyMap)property;
                ConfigurationMaskingUtility.maskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
            }
        }
    }

    private static void maskPropertyMap(AbstractPropertyMap propertyMap, PropertyDefinitionMap propertyDefinitionMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.maskProperty(childPropertyDefinition, propertyMap);
        }
    }

    private static void unmaskProperty(PropertyDefinition propertyDefinition, AbstractPropertyMap parentPropertyMap) {
        PropertyDefinitionList propertyDefinitionList;
        PropertyDefinition listMemberPropertyDefinition;
        if (parentPropertyMap.get(propertyDefinition.getName()) == null) {
            return;
        }
        if (propertyDefinition instanceof PropertyDefinitionSimple) {
            PropertySimple propertySimple;
            PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)propertyDefinition;
            if (propertyDefinitionSimple.getType() == PropertySimpleType.PASSWORD && MASKED_PROPERTY_VALUE.equals((propertySimple = parentPropertyMap.getSimple(propertyDefinition.getName())).getStringValue())) {
                if (MASKED_PROPERTY_VALUE.equals(propertySimple.getUnmaskedStringValue())) {
                    throw new IllegalStateException("Unmasked string value of property '" + propertySimple.getName() + "' is set to MASKED_PROPERTY_VALUE - something went very wrong.");
                }
                propertySimple.setStringValue(propertySimple.getUnmaskedStringValue());
            }
        } else if (propertyDefinition instanceof PropertyDefinitionMap) {
            PropertyMap propertyMap = parentPropertyMap.getMap(propertyDefinition.getName());
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)propertyDefinition;
            ConfigurationMaskingUtility.unmaskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
        } else if (propertyDefinition instanceof PropertyDefinitionList && (listMemberPropertyDefinition = (propertyDefinitionList = (PropertyDefinitionList)propertyDefinition).getMemberDefinition()) instanceof PropertyDefinitionMap) {
            PropertyDefinitionMap propertyDefinitionMap = (PropertyDefinitionMap)listMemberPropertyDefinition;
            PropertyList propertyList = parentPropertyMap.getList(propertyDefinition.getName());
            for (int i = 0; i < propertyList.getList().size(); ++i) {
                PropertyMap propertyMap = (PropertyMap)propertyList.getList().get(i);
                ConfigurationMaskingUtility.unmaskPropertyMap((AbstractPropertyMap)propertyMap, propertyDefinitionMap);
            }
        }
    }

    private static void unmaskPropertyMap(AbstractPropertyMap propertyMap, PropertyDefinitionMap propertyDefinitionMap) {
        Map childPropertyDefinitions = propertyDefinitionMap.getPropertyDefinitions();
        for (PropertyDefinition childPropertyDefinition : childPropertyDefinitions.values()) {
            ConfigurationMaskingUtility.unmaskProperty(childPropertyDefinition, propertyMap);
        }
    }
}

