/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.deploy.actions;

import java.net.URL;
import org.jboss.deployers.spi.management.deploy.DeploymentID;
import org.jboss.profileservice.deployment.ProfileDeploymentFactory;
import org.jboss.profileservice.management.event.ProfileModificationEvent;
import org.jboss.profileservice.plugins.deploy.TransientDeploymentMetaData;
import org.jboss.profileservice.plugins.deploy.actions.AbstractDeploymentAddAction;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.action.ProfileModificationResponse;
import org.jboss.profileservice.spi.action.ProfileModificationType;
import org.jboss.profileservice.spi.action.deployment.DeploymentAction;
import org.jboss.profileservice.spi.action.deployment.DeploymentActionContext;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class DeploymentAddAction
extends AbstractDeploymentAddAction
implements DeploymentAction<DeploymentActionContext> {
    private static final ProfileDeploymentFactory deploymentFactory = ProfileDeploymentFactory.getInstance();

    public DeploymentAddAction(DeploymentID dtID, MutableProfile profile, DeploymentActionContext modificationContext) {
        super(dtID, profile, modificationContext);
    }

    protected void doCancel() {
    }

    protected void doCommit(ProfileModificationResponse response) {
    }

    protected void doComplete(ProfileModificationResponse response) throws Exception {
    }

    protected boolean doPrepare(ProfileModificationResponse response) {
        try {
            String name = this.getDeploymentName();
            URL url = this.getDeploymentID().getContentURL();
            if (url == null) {
                return false;
            }
            VirtualFile vf = VFS.getChild((URL)url);
            ProfileDeployment deployment = deploymentFactory.createDeployment(vf, (VirtualDeploymentMetaData)new TransientDeploymentMetaData(name));
            deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
            deployment.getTransientAttachments().putAttachment("deployment-url", (Object)url.toExternalForm());
            this.getProfile().addDeployment(deployment);
            response.fireModificationEvent(ProfileModificationEvent.create((ProfileModificationType)ProfileModificationType.ADD, (ProfileKey)this.getProfile().getKey()));
        }
        catch (Exception e) {
            response.setFailure((Throwable)e);
            return false;
        }
        return true;
    }

    protected void doRollbackFromActive() {
    }

    protected void doRollbackFromCancelled() {
    }

    protected void doRollbackFromComplete() {
    }

    protected void doRollbackFromPrepared() {
        String name = this.getDeploymentName();
        if (this.getProfile().hasDeployment(name)) {
            try {
                this.getProfile().removeDeployment(name);
            }
            catch (Exception e) {
                log.error((Object)("failed to rollback changes " + name));
            }
        }
    }

    protected void doRollbackFromRollbackOnly() {
    }
}

