/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.channels.ReadTimeoutException;
import org.jboss.xnio.channels.StreamSourceChannel;

public class ChannelInputStream
extends InputStream {
    protected final StreamSourceChannel channel;
    protected volatile boolean closed;
    protected volatile long timeout;

    public ChannelInputStream(StreamSourceChannel channel) {
        this.channel = channel;
    }

    public ChannelInputStream(StreamSourceChannel channel, long timeout, TimeUnit timeoutUnit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        this.channel = channel;
        long calcTimeout = timeoutUnit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public long getReadTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative timeout");
        }
        long calcTimeout = unit.toMillis(timeout);
        this.timeout = timeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        byte[] array = new byte[1];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        long timeout = this.timeout;
        if (timeout == 0L) {
            do {
                int res;
                if ((res = this.channel.read(buffer)) == -1) {
                    return -1;
                }
                if (res == 1) {
                    return array[0] & 0xFF;
                }
                this.channel.awaitReadable();
            } while (!this.closed);
            return -1;
        }
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        int res;
        while ((res = this.channel.read(buffer)) != -1) {
            if (res == 1) {
                return array[0] & 0xFF;
            }
            if (now >= deadline) {
                throw new ReadTimeoutException("Read timed out");
            }
            this.channel.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            if (this.closed) {
                return -1;
            }
            now = System.currentTimeMillis();
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        long timeout = this.timeout;
        if (timeout == 0L) {
            do {
                int res;
                if ((res = this.channel.read(buffer)) == -1) {
                    return -1;
                }
                if (res > 0) {
                    return res;
                }
                try {
                    this.channel.awaitReadable();
                }
                catch (InterruptedIOException e) {
                    e.bytesTransferred = buffer.position();
                    throw e;
                }
            } while (!this.closed);
            return -1;
        }
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        int res;
        while ((res = this.channel.read(buffer)) != -1) {
            if (res > 0) {
                return res;
            }
            try {
                if (now >= deadline) {
                    throw new ReadTimeoutException("Read timed out");
                }
                this.channel.awaitReadable(deadline - now, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedIOException e) {
                e.bytesTransferred = buffer.position();
                throw e;
            }
            if (this.closed) {
                return -1;
            }
            now = System.currentTimeMillis();
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.channel.shutdownReads();
    }
}

