/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.ManagedSocket;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.management.TcpServerMBean;

final class ManagedServerSocket
extends ServerSocket {
    private final OptionMap optionMap;
    private static final AtomicLongFieldUpdater<ManagedServerSocket> acceptedConnectionsUpdater = AtomicLongFieldUpdater.newUpdater(ManagedServerSocket.class, "acceptedConnections");
    private volatile long acceptedConnections = 0L;
    private volatile Closeable registration;
    private static final TcpServerMBean.Listener[] NONE = new TcpServerMBean.Listener[0];

    ManagedServerSocket(OptionMap optionMap) throws IOException {
        this.optionMap = optionMap;
    }

    ManagedServerSocket(int port, OptionMap optionMap) throws IOException {
        super(port, optionMap.get(Options.BACKLOG, 0));
        this.optionMap = optionMap;
    }

    ManagedServerSocket(int port, int backlog, OptionMap optionMap) throws IOException {
        super(port, backlog);
        this.optionMap = optionMap;
    }

    ManagedServerSocket(int port, int backlog, InetAddress bindAddr, OptionMap optionMap) throws IOException {
        super(port, backlog, bindAddr);
        this.optionMap = optionMap;
    }

    @Override
    public Socket accept() throws IOException {
        OptionMap optionMap = this.optionMap;
        ManagedSocket socket = new ManagedSocket();
        this.implAccept(socket);
        socket.configure(optionMap);
        acceptedConnectionsUpdater.getAndIncrement(this);
        return socket;
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        super.bind(endpoint, this.optionMap.get(Options.BACKLOG, 0));
    }

    void setRegistration(Closeable registration) {
        this.registration = registration;
    }

    MBean getMBean() throws NotCompliantMBeanException {
        return new MBean();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            IoUtils.safeClose(this.registration);
        }
    }

    private final class MBean
    extends StandardMBean
    implements TcpServerMBean {
        public MBean() throws NotCompliantMBeanException {
            super(TcpServerMBean.class);
        }

        public String toString() {
            return "TCPServerMBean";
        }

        @Override
        public TcpServerMBean.Listener[] getBoundListeners() {
            final SocketAddress local = ManagedServerSocket.this.getLocalSocketAddress();
            if (local == null) {
                return NONE;
            }
            return new TcpServerMBean.Listener[]{new TcpServerMBean.Listener(){

                @Override
                public InetSocketAddress getBindAddress() {
                    InetSocketAddress lsa = (InetSocketAddress)local;
                    if (lsa == null) {
                        return new InetSocketAddress(0);
                    }
                    return lsa;
                }

                @Override
                public long getAcceptedConnections() {
                    return ManagedServerSocket.this.acceptedConnections;
                }
            }};
        }

        @Override
        public long getAcceptedConnections() {
            return ManagedServerSocket.this.acceptedConnections;
        }

        @Override
        public void bind(InetSocketAddress address) throws IOException {
            throw new IOException("Cannot bind this socket type");
        }

        @Override
        public void bind(String hostName, int port) throws IOException {
            throw new IOException("Cannot bind this socket type");
        }

        @Override
        public void unbind(InetSocketAddress address) throws IOException {
            throw new IOException("Cannot unbind this socket type");
        }

        @Override
        public void unbind(String hostName, int port) throws IOException {
            throw new IOException("Cannot unbind this socket type");
        }

        @Override
        public void close() {
            IoUtils.safeClose(ManagedServerSocket.this);
        }
    }
}

