/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.persistence.component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.profileservice.persistence.component.ComponentMapper;

public class ComponentMapperRegistry {
    private static final ComponentMapperRegistry INSTANCE = new ComponentMapperRegistry();
    private final Map<String, ComponentMapper> map = new ConcurrentHashMap<String, ComponentMapper>();

    protected ComponentMapperRegistry() {
    }

    public static ComponentMapperRegistry getInstance() {
        return INSTANCE;
    }

    public ComponentMapper getMapper(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        return this.map.get(name);
    }

    public void addMapper(ComponentMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("null mapper");
        }
        this.map.put(mapper.getType(), mapper);
    }

    public void addMapper(String type, ComponentMapper mapper) {
        if (type == null) {
            throw new IllegalArgumentException("null mapper type");
        }
        this.map.put(type, mapper);
    }

    public ComponentMapper removeComponentMapper(ComponentMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("null mapper");
        }
        return this.removeComponentMapper(mapper.getType());
    }

    public ComponentMapper removeComponentMapper(String type) {
        if (type == null) {
            throw new IllegalArgumentException("null mapper type");
        }
        return this.map.remove(type);
    }
}

