/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;

public class WebConfiguration {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern ALLOWABLE_BOOLEANS = Pattern.compile("true|false");
    private static final String WEB_CONFIG_KEY = "com.sun.faces.config.WebConfiguration";
    private Level loggingLevel = Level.FINE;
    private Map<BooleanWebContextInitParameter, Boolean> booleanContextParameters = new EnumMap<BooleanWebContextInitParameter, Boolean>(BooleanWebContextInitParameter.class);
    private Map<WebContextInitParameter, String> contextParameters = new EnumMap<WebContextInitParameter, String>(WebContextInitParameter.class);
    private Map<WebEnvironmentEntry, String> envEntries = new EnumMap<WebEnvironmentEntry, String>(WebEnvironmentEntry.class);
    private Map<WebContextInitParameter, String[]> cachedListParams;
    private Set<String> setParams = new HashSet<String>();
    private ServletContext servletContext;
    private ArrayList<DeferredLoggingAction> deferredLoggingActions;

    private WebConfiguration(ServletContext servletContext) {
        this.servletContext = servletContext;
        String contextName = this.getServletContextName();
        this.initSetList(servletContext);
        this.processBooleanParameters(servletContext, contextName);
        this.processInitParameters(servletContext, contextName);
        if (this.canProcessJndiEntries()) {
            this.processJndiEntries(contextName);
        }
        this.cachedListParams = new HashMap<WebContextInitParameter, String[]>(3);
        this.getOptionValue(WebContextInitParameter.ResourceExcludes, " ");
        this.getOptionValue(WebContextInitParameter.DefaultSuffix, " ");
        this.getOptionValue(WebContextInitParameter.FaceletsViewMappings, ";");
    }

    public static WebConfiguration getInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return WebConfiguration.getInstance(facesContext.getExternalContext());
    }

    public static WebConfiguration getInstance(ExternalContext extContext) {
        WebConfiguration config = (WebConfiguration)extContext.getApplicationMap().get(WEB_CONFIG_KEY);
        if (config == null) {
            return WebConfiguration.getInstance((ServletContext)extContext.getContext());
        }
        return config;
    }

    public static WebConfiguration getInstance(ServletContext servletContext) {
        WebConfiguration webConfig = (WebConfiguration)servletContext.getAttribute(WEB_CONFIG_KEY);
        if (webConfig == null) {
            webConfig = new WebConfiguration(servletContext);
            servletContext.setAttribute(WEB_CONFIG_KEY, (Object)webConfig);
        }
        return webConfig;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isOptionEnabled(BooleanWebContextInitParameter param) {
        if (this.booleanContextParameters.get((Object)param) != null) {
            return this.booleanContextParameters.get((Object)param);
        }
        return param.getDefaultValue();
    }

    public String getOptionValue(WebContextInitParameter param) {
        WebContextInitParameter alternate;
        String result = this.contextParameters.get((Object)param);
        if (null == result && null != (alternate = param.getAlternate())) {
            result = this.contextParameters.get((Object)alternate);
        }
        return result;
    }

    public String[] getOptionValue(WebContextInitParameter param, String sep) {
        assert (null != this.cachedListParams);
        String[] result = this.cachedListParams.get((Object)param);
        if (null == result) {
            String value = this.getOptionValue(param);
            result = null == value ? new String[]{} : Util.split(value, sep);
            this.cachedListParams.put(param, result);
        }
        return result;
    }

    public String getEnvironmentEntry(WebEnvironmentEntry entry) {
        return this.envEntries.get((Object)entry);
    }

    public boolean isSet(WebContextInitParameter param) {
        return this.isSet(param.getQualifiedName());
    }

    public boolean isSet(BooleanWebContextInitParameter param) {
        return this.isSet(param.getQualifiedName());
    }

    public String getServletContextName() {
        if (this.servletContext.getMajorVersion() == 2 && this.servletContext.getMinorVersion() <= 4) {
            return this.servletContext.getServletContextName();
        }
        return this.servletContext.getContextPath();
    }

    public void overrideContextInitParameter(BooleanWebContextInitParameter param, boolean value) {
        if (param == null) {
            return;
        }
        boolean oldVal = this.booleanContextParameters.put(param, value);
        if (LOGGER.isLoggable(Level.FINE) && oldVal != value) {
            LOGGER.log(Level.FINE, "Overriding init parameter {0}.  Changing from {1} to {2}.", new Object[]{param.getQualifiedName(), oldVal, value});
        }
    }

    public void overrideContextInitParameter(WebContextInitParameter param, String value) {
        if (param == null || value == null || value.length() == 0) {
            return;
        }
        value = value.trim();
        String oldVal = this.contextParameters.put(param, value);
        this.cachedListParams.remove((Object)param);
        if (oldVal != null && LOGGER.isLoggable(Level.FINE) && !oldVal.equals(value)) {
            LOGGER.log(Level.FINE, "Overriding init parameter {0}.  Changing from {1} to {2}.", new Object[]{param.getQualifiedName(), oldVal, value});
        }
    }

    public void doLoggingActions() {
        if (this.deferredLoggingActions != null) {
            for (DeferredLoggingAction loggingAction : this.deferredLoggingActions) {
                loggingAction.log();
            }
        }
    }

    static void clear(ServletContext servletContext) {
        servletContext.removeAttribute(WEB_CONFIG_KEY);
    }

    private boolean isValueValid(BooleanWebContextInitParameter param, String value) {
        if (!ALLOWABLE_BOOLEANS.matcher(value).matches()) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.config.webconfig.boolconfig.invalidvalue", new Object[]{value, param.getQualifiedName(), "true|false"});
            }
            return false;
        }
        return true;
    }

    private void processBooleanParameters(ServletContext servletContext, String contextName) {
        for (BooleanWebContextInitParameter param : BooleanWebContextInitParameter.values()) {
            boolean value;
            String strValue = servletContext.getInitParameter(param.getQualifiedName());
            if (strValue != null && strValue.length() > 0 && param.isDeprecated()) {
                BooleanWebContextInitParameter alternate = param.getAlternate();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    if (alternate != null) {
                        this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(param, Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, param.getQualifiedName(), alternate.getQualifiedName()}));
                    } else {
                        this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(param, Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{contextName, param.getQualifiedName()}));
                    }
                }
                if (alternate == null) continue;
                value = this.isValueValid(param, strValue) ? Boolean.valueOf(strValue).booleanValue() : param.getDefaultValue();
                if (LOGGER.isLoggable(Level.INFO) && alternate != null) {
                    this.queueLoggingAction(new DeferredBooleanParameterLoggingAction(param, Level.INFO, value ? "jsf.config.webconfig.configinfo.reset.enabled" : "jsf.config.webconfig.configinfo.reset.disabled", new Object[]{contextName, alternate.getQualifiedName()}));
                }
                this.booleanContextParameters.put(alternate, value);
                continue;
            }
            if (param.isDeprecated()) continue;
            value = strValue == null ? param.getDefaultValue() : (this.isValueValid(param, strValue) ? Boolean.valueOf(strValue).booleanValue() : param.getDefaultValue());
            if (BooleanWebContextInitParameter.DisplayConfiguration.equals((Object)param) && value) {
                this.loggingLevel = Level.INFO;
            }
            if (LOGGER.isLoggable(this.loggingLevel)) {
                LOGGER.log(this.loggingLevel, value ? "jsf.config.webconfig.boolconfiginfo.enabled" : "jsf.config.webconfig.boolconfiginfo.disabled", new Object[]{contextName, param.getQualifiedName()});
            }
            this.booleanContextParameters.put(param, value);
        }
    }

    private void initSetList(ServletContext servletContext) {
        Enumeration e = servletContext.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            if (!name.startsWith("com.sun.faces") && !name.startsWith("javax.faces")) continue;
            this.setParams.add(name);
        }
    }

    private boolean isSet(String name) {
        return this.setParams.contains(name);
    }

    private void processInitParameters(ServletContext servletContext, String contextName) {
        for (WebContextInitParameter param : WebContextInitParameter.values()) {
            String value = servletContext.getInitParameter(param.getQualifiedName());
            if (value != null && value.length() > 0 && param.isDeprecated()) {
                WebContextInitParameter alternate = param.getAlternate();
                DeprecationLoggingStrategy strategy = param.getDeprecationLoggingStrategy();
                if ((strategy == null || strategy.shouldBeLogged(this)) && LOGGER.isLoggable(Level.WARNING)) {
                    if (alternate != null) {
                        this.queueLoggingAction(new DeferredParameterLoggingAction(param, Level.WARNING, "jsf.config.webconfig.param.deprecated", new Object[]{contextName, param.getQualifiedName(), alternate.getQualifiedName()}));
                    } else {
                        this.queueLoggingAction(new DeferredParameterLoggingAction(param, Level.WARNING, "jsf.config.webconfig.param.deprecated.no_replacement", new Object[]{contextName, param.getQualifiedName()}));
                    }
                }
                if (alternate == null) continue;
                this.queueLoggingAction(new DeferredParameterLoggingAction(param, Level.INFO, "jsf.config.webconfig.configinfo.reset", new Object[]{contextName, alternate.getQualifiedName(), value}));
                this.contextParameters.put(alternate, value);
                continue;
            }
            if (!(value != null && value.length() != 0 || param.isDeprecated())) {
                value = param.getDefaultValue();
            }
            if (value == null || value.length() == 0) continue;
            if (value.length() > 0) {
                if (LOGGER.isLoggable(this.loggingLevel)) {
                    LOGGER.log(this.loggingLevel, "jsf.config.webconfig.configinfo", new Object[]{contextName, param.getQualifiedName(), value});
                }
                this.contextParameters.put(param, value);
                continue;
            }
            if (!LOGGER.isLoggable(this.loggingLevel)) continue;
            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.option.notconfigured", new Object[]{contextName, param.getQualifiedName()});
        }
    }

    private void processJndiEntries(String contextName) {
        InitialContext initialContext;
        block11: {
            initialContext = null;
            try {
                initialContext = new InitialContext();
            }
            catch (NamingException ne) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block11;
                LOGGER.log(Level.WARNING, ne.toString(), ne);
            }
        }
        if (initialContext != null) {
            for (WebEnvironmentEntry entry : WebEnvironmentEntry.values()) {
                String value;
                String entryName;
                block12: {
                    entryName = entry.getQualifiedName();
                    value = null;
                    try {
                        value = (String)initialContext.lookup(entryName);
                    }
                    catch (NamingException root) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block12;
                        LOGGER.fine(root.toString());
                    }
                }
                if (value == null) continue;
                if (LOGGER.isLoggable(Level.INFO)) {
                    if (!entry.equals((Object)WebEnvironmentEntry.ClientStateSavingPassword)) {
                        if (LOGGER.isLoggable(this.loggingLevel)) {
                            LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventryinfo", new Object[]{contextName, entryName, value});
                        }
                    } else if (LOGGER.isLoggable(this.loggingLevel)) {
                        LOGGER.log(this.loggingLevel, "jsf.config.webconfig.enventry.clientencrypt", contextName);
                    }
                }
                this.envEntries.put(entry, value);
            }
        }
    }

    private boolean canProcessJndiEntries() {
        try {
            Util.getCurrentLoader(this).loadClass("javax.naming.InitialContext");
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("javax.naming is unavailable.  JNDI entries related to Mojarra configuration will not be processed.");
            }
            return false;
        }
        return true;
    }

    private void queueLoggingAction(DeferredLoggingAction loggingAction) {
        if (this.deferredLoggingActions == null) {
            this.deferredLoggingActions = new ArrayList();
        }
        this.deferredLoggingActions.add(loggingAction);
    }

    private class DeferredBooleanParameterLoggingAction
    implements DeferredLoggingAction {
        private BooleanWebContextInitParameter parameter;
        private Level loggingLevel;
        private String logKey;
        private Object[] params;

        DeferredBooleanParameterLoggingAction(BooleanWebContextInitParameter parameter, Level loggingLevel, String logKey, Object[] params) {
            this.parameter = parameter;
            this.loggingLevel = loggingLevel;
            this.logKey = logKey;
            this.params = params;
        }

        public void log() {
            DeprecationLoggingStrategy strategy;
            if (LOGGER.isLoggable(this.loggingLevel) && (strategy = this.parameter.getDeprecationLoggingStrategy()) != null && strategy.shouldBeLogged(WebConfiguration.this)) {
                LOGGER.log(this.loggingLevel, this.logKey, this.params);
            }
        }
    }

    private class DeferredParameterLoggingAction
    implements DeferredLoggingAction {
        private WebContextInitParameter parameter;
        private Level loggingLevel;
        private String logKey;
        private Object[] params;

        DeferredParameterLoggingAction(WebContextInitParameter parameter, Level loggingLevel, String logKey, Object[] params) {
            this.parameter = parameter;
            this.loggingLevel = loggingLevel;
            this.logKey = logKey;
            this.params = params;
        }

        public void log() {
            DeprecationLoggingStrategy strategy;
            if (LOGGER.isLoggable(this.loggingLevel) && (strategy = this.parameter.getDeprecationLoggingStrategy()) != null && strategy.shouldBeLogged(WebConfiguration.this)) {
                LOGGER.log(this.loggingLevel, this.logKey, this.params);
            }
        }
    }

    private static interface DeferredLoggingAction {
        public void log();
    }

    private static class FaceletsConfigParamLoggingStrategy
    implements DeprecationLoggingStrategy {
        private FaceletsConfigParamLoggingStrategy() {
        }

        public boolean shouldBeLogged(WebConfiguration configuration) {
            return !configuration.isOptionEnabled(BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        }
    }

    private static interface DeprecationLoggingStrategy {
        public boolean shouldBeLogged(WebConfiguration var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisableUnicodeEscaping {
        True("true"),
        False("false"),
        Auto("auto");

        private final String value;

        private DisableUnicodeEscaping(String value) {
            this.value = value;
        }

        public static DisableUnicodeEscaping getByValue(String value) {
            for (DisableUnicodeEscaping disableUnicodeEscaping : DisableUnicodeEscaping.values()) {
                if (!disableUnicodeEscaping.value.equals(value)) continue;
                return disableUnicodeEscaping;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebEnvironmentEntry {
        ClientStateSavingPassword("ClientStateSavingPassword"),
        ProjectStage("java:comp/env/jsf/ProjectStage");

        private static final String JNDI_PREFIX = "java:comp/env/";
        private String qualifiedName;

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        private WebEnvironmentEntry(String qualifiedName) {
            this.qualifiedName = qualifiedName.startsWith(JNDI_PREFIX) ? qualifiedName : JNDI_PREFIX + qualifiedName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BooleanWebContextInitParameter {
        DisplayConfiguration("com.sun.faces.displayConfiguration", false),
        ValidateFacesConfigFiles("com.sun.faces.validateXml", false),
        VerifyFacesConfigObjects("com.sun.faces.verifyObjects", false),
        ForceLoadFacesConfigFiles("com.sun.faces.forceLoadConfiguration", false),
        DisableArtifactVersioning("com.sun.faces.disableVersionTracking", false, true, null),
        EnableHtmlTagLibraryValidator("com.sun.faces.enableHtmlTagLibValidator", false),
        EnableCoreTagLibraryValidator("com.sun.faces.enableCoreTagLibValidator", false),
        PreferXHTMLContentType("com.sun.faces.preferXHTML", false),
        PreferXHTMLContextTypeDeprecated("com.sun.faces.PreferXHTML", false, true, PreferXHTMLContentType),
        CompressViewState("com.sun.faces.compressViewState", true),
        CompressViewStateDeprecated("com.sun.faces.COMPRESS_STATE", true, true, CompressViewState),
        CompressJavaScript("com.sun.faces.compressJavaScript", true),
        ExternalizeJavaScriptDeprecated("com.sun.faces.externalizeJavaScript", true, true, null),
        SendPoweredByHeader("com.sun.faces.sendPoweredByHeader", true),
        EnableJSStyleHiding("com.sun.faces.enableJSStyleHiding", false),
        EnableScriptInAttributeValue("com.sun.faces.enableScriptsInAttributeValues", true),
        WriteStateAtFormEnd("com.sun.faces.writeStateAtFormEnd", true),
        EnableLazyBeanValidation("com.sun.faces.enableLazyBeanValidation", true),
        EnableLoadBundle11Compatibility("com.sun.faces.enabledLoadBundle11Compatibility", false),
        EnableRestoreView11Compatibility("com.sun.faces.enableRestoreView11Compatibility", false),
        SerializeServerState("com.sun.faces.serializeServerState", false),
        EnableViewStateIdRendering("com.sun.faces.enableViewStateIdRendering", true),
        RegisterConverterPropertyEditors("com.sun.faces.registerConverterPropertyEditors", false),
        EnableGroovyScripting("com.sun.faces.enableGroovyScripting", false),
        DisableFaceletJSFViewHandler("javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER", false),
        DisableDefaultBeanValidator("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR", false),
        DateTimeConverterUsesSystemTimezone("javax.faces.DATETIMECONVERTER_DEFAULT_TIMEZONE_IS_SYSTEM_TIMEZONE", false),
        FaceletsSkipComments("javax.faces.FACELETS_SKIP_COMMENTS", false),
        FaceletsSkipCommentsDeprecated("facelets.SKIP_COMMENTS", false, true, FaceletsSkipComments, new FaceletsConfigParamLoggingStrategy()),
        PartialStateSaving("javax.faces.PARTIAL_STATE_SAVING", true),
        GenerateUniqueServerStateIds("com.sun.faces.generateUniqueServerStateIds", true),
        AutoCompleteOffOnViewState("com.sun.faces.autoCompleteOffOnViewState", true),
        EnableThreading("com.sun.faces.enableThreading", false),
        AllowTextChildren("com.sun.faces.allowTextChildren", false),
        CacheResourceModificationTimestamp("com.sun.faces.cacheResourceModificationTimestamp", false);

        private BooleanWebContextInitParameter alternate;
        private String qualifiedName;
        private boolean defaultValue;
        private boolean deprecated;
        private DeprecationLoggingStrategy loggingStrategy;

        public boolean getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        DeprecationLoggingStrategy getDeprecationLoggingStrategy() {
            return this.loggingStrategy;
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue, boolean deprecated, BooleanWebContextInitParameter alternate) {
            this.qualifiedName = qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        private BooleanWebContextInitParameter(String qualifiedName, boolean defaultValue, boolean deprecated, BooleanWebContextInitParameter alternate, DeprecationLoggingStrategy loggingStrategy) {
            this(qualifiedName, defaultValue, deprecated, alternate);
            this.loggingStrategy = loggingStrategy;
        }

        private BooleanWebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WebContextInitParameter {
        ManagedBeanFactoryDecorator("com.sun.faces.managedBeanFactoryDecoratorClass", ""),
        StateSavingMethod("javax.faces.STATE_SAVING_METHOD", "server"),
        FaceletsSuffix("javax.faces.FACELETS_SUFFIX", ".xhtml"),
        DefaultSuffix("javax.faces.DEFAULT_SUFFIX", ".xhtml .jsp"),
        JavaxFacesConfigFiles("javax.faces.CONFIG_FILES", ""),
        JavaxFacesProjectStage("javax.faces.PROJECT_STAGE", "Production"),
        AlternateLifecycleId("javax.faces.LIFECYCLE_ID", ""),
        ResourceExcludes("javax.faces.RESOURCE_EXCLUDES", ".class .jsp .jspx .properties .xhtml .groovy"),
        NumberOfViews("com.sun.faces.numberOfViewsInSession", "15"),
        NumberOfViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION", "15", true, NumberOfViews),
        NumberOfLogicalViews("com.sun.faces.numberOfLogicalViews", "15"),
        NumberOfLogicalViewsDeprecated("com.sun.faces.NUMBER_OF_VIEWS_IN_LOGICAL_VIEW_IN_SESSION", "15", true, NumberOfLogicalViews),
        NumberOfConcurrentFlashUsers("com.sun.faces.numberOfConcerrentFlashUsers", "5000"),
        NumberOfFlashesBetweenFlashReapings("com.sun.faces.numberOfFlashesBetweenFlashReapings", "5000"),
        InjectionProviderClass("com.sun.faces.injectionProvider", ""),
        SerializationProviderClass("com.sun.faces.serializationProvider", ""),
        ResponseBufferSize("com.sun.faces.responseBufferSize", "1024"),
        FaceletsBufferSize("javax.faces.FACELETS_BUFFER_SIZE", "1024"),
        FaceletsBufferSizeDeprecated("facelets.BUFFER_SIZE", "1024", true, FaceletsBufferSize, new FaceletsConfigParamLoggingStrategy()),
        ClientStateWriteBufferSize("com.sun.faces.clientStateWriteBufferSize", "8192"),
        ResourceBufferSize("com.sun.faces.resourceBufferSize", "2048"),
        ExpressionFactory("com.sun.faces.expressionFactory", "com.sun.el.ExpressionFactoryImpl"),
        ClientStateTimeout("com.sun.faces.clientStateTimeout", ""),
        DefaultResourceMaxAge("com.sun.faces.defaultResourceMaxAge", "604800000"),
        ResourceUpdateCheckPeriod("com.sun.faces.resourceUpdateCheckPeriod", "5"),
        CompressableMimeTypes("com.sun.faces.compressableMimeTypes", ""),
        DisableUnicodeEscaping("com.sun.faces.disableUnicodeEscaping", "auto"),
        FaceletsDefaultRefreshPeriod("javax.faces.FACELETS_REFRESH_PERIOD", "2"),
        FaceletsDefaultRefreshPeriodDeprecated("facelets.REFRESH_PERIOD", "2", true, FaceletsDefaultRefreshPeriod, new FaceletsConfigParamLoggingStrategy()),
        FaceletsResourceResolver("javax.faces.FACELETS_RESOURCE_RESOLVER", ""),
        FaceletsResourceResolverDeprecated("facelets.RESOURCE_RESOLVER", "", true, FaceletsResourceResolver, new FaceletsConfigParamLoggingStrategy()),
        FaceletsViewMappings("javax.faces.FACELETS_VIEW_MAPPINGS", ""),
        FaceletsViewMappingsDeprecated("facelets.VIEW_MAPPINGS", "", true, FaceletsViewMappings, new FaceletsConfigParamLoggingStrategy()),
        FaceletsLibraries("javax.faces.FACELETS_LIBRARIES", ""),
        FaceletsLibrariesDeprecated("facelets.LIBRARIES", "", true, FaceletsLibraries, new FaceletsConfigParamLoggingStrategy()),
        FaceletsDecorators("javax.faces.FACELETS_DECORATORS", ""),
        FaceletsDecoratorsDeprecated("facelets.DECORATORS", "", true, FaceletsDecorators, new FaceletsConfigParamLoggingStrategy()),
        DuplicateJARPattern("com.sun.faces.duplicateJARPattern", ""),
        ValidateEmptyFields("javax.faces.VALIDATE_EMPTY_FIELDS", "auto"),
        FullStateSavingViewIds("javax.faces.FULL_STATE_SAVING_VIEW_IDS", ""),
        AnnotationScanPackages("com.sun.faces.annotationScanPackages", ""),
        FaceletFactory("com.sun.faces.faceletFactory", ""),
        FaceletCache("com.sun.faces.faceletCache", "");

        private String defaultValue;
        private String qualifiedName;
        private WebContextInitParameter alternate;
        private boolean deprecated;
        private DeprecationLoggingStrategy loggingStrategy;

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        DeprecationLoggingStrategy getDeprecationLoggingStrategy() {
            return this.loggingStrategy;
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue) {
            this(qualifiedName, defaultValue, false, null);
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue, boolean deprecated, WebContextInitParameter alternate) {
            this.qualifiedName = qualifiedName;
            this.defaultValue = defaultValue;
            this.deprecated = deprecated;
            this.alternate = alternate;
        }

        private WebContextInitParameter(String qualifiedName, String defaultValue, boolean deprecated, WebContextInitParameter alternate, DeprecationLoggingStrategy loggingStrategy) {
            this(qualifiedName, defaultValue, deprecated, alternate);
            this.loggingStrategy = loggingStrategy;
        }

        private WebContextInitParameter getAlternate() {
            return this.alternate;
        }

        private boolean isDeprecated() {
            return this.deprecated;
        }
    }
}

