/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.system.InterceptorServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public abstract class InterceptorServiceMBeanSupport
extends ServiceMBeanSupport
implements InterceptorServiceMBean {
    private List interceptables;
    private Interceptor interceptor;

    public InterceptorServiceMBeanSupport() {
    }

    public InterceptorServiceMBeanSupport(Class type) {
        super(type);
    }

    public InterceptorServiceMBeanSupport(String category) {
        super(category);
    }

    public InterceptorServiceMBeanSupport(Logger log) {
        super(log);
    }

    public void setInterceptables(List interceptables) {
        if (interceptables != null) {
            this.interceptables = new ArrayList(interceptables);
        }
    }

    public List getInterceptables() {
        if (this.interceptables != null) {
            return new ArrayList(this.interceptables);
        }
        return null;
    }

    protected void attach() throws Exception {
        if (this.interceptor == null) {
            this.attach((Interceptor)new XMBeanInterceptor());
        }
    }

    protected void attach(Interceptor interceptor) throws Exception {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null interceptor");
        }
        if (this.interceptor != null) {
            throw new IllegalStateException("Interceptor already attached");
        }
        this.log.debugf("Attaching interceptor: %1s", new Object[]{interceptor.getName()});
        this.interceptor = interceptor;
        if (this.interceptables != null) {
            Object[] params = new Object[]{interceptor};
            String[] signature = new String[]{Interceptor.class.getName()};
            for (ObjectName target : this.interceptables) {
                this.server.invoke(target, "addOperationInterceptor", params, signature);
                this.log.debugf("Interceptor attached to: '%1s'", new Object[]{target});
            }
        }
    }

    protected void detach() {
        if (this.interceptor != null) {
            this.log.debugf("Detaching interceptor: %1s", new Object[]{this.interceptor.getName()});
            if (this.interceptables != null) {
                Object[] params = new Object[]{this.interceptor};
                String[] signature = new String[]{Interceptor.class.getName()};
                for (ObjectName target : this.interceptables) {
                    try {
                        this.server.invoke(target, "removeOperationInterceptor", params, signature);
                        this.log.debugf("Interceptor detached from: '%1s'", new Object[]{target});
                    }
                    catch (Exception e) {
                        this.log.debugf((Throwable)e, "Caught exception while removing interceptor from '%1s'", new Object[]{target});
                    }
                }
            }
            this.interceptor = null;
        }
    }

    protected Object invokeNext(Invocation invocation) throws Throwable {
        AbstractInterceptor next = invocation.nextInterceptor();
        if (next != null) {
            return next.invoke(invocation);
        }
        return invocation.dispatch();
    }

    protected Object invoke(Invocation invocation) throws Throwable {
        return this.invokeNext(invocation);
    }

    private class XMBeanInterceptor
    extends AbstractInterceptor {
        public XMBeanInterceptor() {
            super("XMBeanInterceptor('" + InterceptorServiceMBeanSupport.this.getServiceName() + "')");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return InterceptorServiceMBeanSupport.this.invoke(invocation);
        }
    }
}

