/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.PropertyMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.resource.metadata.mcf.DataSourceConnectionPropertyMetaData;
import org.jboss.resource.metadata.mcf.DataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.LocalDataSourceDeploymentMetaData;
import org.jboss.resource.metadata.mcf.NoTxDataSourceDeploymentMetaData;

public class DataSourceDeployerHelper {
    private static final Logger logger = Logger.getLogger(DataSourceDeployerHelper.class);
    private static final List<String> scopes = new ArrayList<String>();

    public static String normalizeJndiName(DataSourceMetaData dsmd, DeploymentUnit unit, JavaEEComponentInformer informer) {
        String refName = dsmd.getName();
        if (refName.startsWith("java:comp/") || refName.startsWith("java:module/") || refName.startsWith("java:app/") || refName.startsWith("java:global/")) {
            return DataSourceDeployerHelper.normalizeJndiName(refName, unit, informer);
        }
        return DataSourceDeployerHelper.normalizeJndiName("env/" + refName, unit, informer);
    }

    public static String normalizeJndiName(String dsJndiName, DeploymentUnit unit, JavaEEComponentInformer informer) {
        String jndiName = DataSourceDeployerHelper.normalizeJndiName(dsJndiName);
        StringBuffer internalJndiName = new StringBuffer();
        String dsName = jndiName;
        if (jndiName.indexOf("/") != -1 && scopes.contains(jndiName.substring(0, jndiName.indexOf("/")))) {
            dsName = jndiName.substring(jndiName.indexOf("/") + 1, jndiName.length());
        }
        internalJndiName.append("internal/" + informer.getApplicationName(unit) + "/" + informer.getModuleName(unit) + "/");
        if (informer.isJavaEEComponent(unit)) {
            internalJndiName.append(informer.getComponentName(unit) + "/");
        }
        return internalJndiName.append(dsName).toString();
    }

    public static DataSourceDeploymentMetaData createDeployment(DataSourceMetaData dsmd) {
        Object deploymentMetaData = null;
        deploymentMetaData = dsmd.isTransactional() ? new LocalDataSourceDeploymentMetaData() : new NoTxDataSourceDeploymentMetaData();
        List connectionProps = deploymentMetaData.getDataSourceConnectionProperties();
        boolean useUrl = true;
        String serverName = dsmd.getServerName();
        String dataBaseName = dsmd.getDatabaseName();
        int portNumber = dsmd.getPortNumber();
        String url = dsmd.getUrl();
        DataSourceConnectionPropertyMetaData connectionProp = null;
        if (serverName != null && !serverName.isEmpty()) {
            useUrl = false;
            connectionProp = new DataSourceConnectionPropertyMetaData();
            connectionProp.setName("serverName");
            connectionProp.setValue(serverName);
            connectionProps.add(connectionProp);
        }
        if (dataBaseName != null && !dataBaseName.isEmpty()) {
            useUrl = false;
            connectionProp = new DataSourceConnectionPropertyMetaData();
            connectionProp.setName("databaseName");
            connectionProp.setValue(dataBaseName);
            connectionProps.add(connectionProp);
        }
        if (portNumber > -1) {
            useUrl = false;
            connectionProp = new DataSourceConnectionPropertyMetaData();
            connectionProp.setName("portNumber");
            connectionProp.setValue(String.valueOf(portNumber));
            connectionProps.add(connectionProp);
        }
        connectionProp = new DataSourceConnectionPropertyMetaData();
        connectionProp.setName("loginTimeout");
        connectionProp.setValue(String.valueOf(dsmd.getLoginTimeout()));
        connectionProps.add(connectionProp);
        if (useUrl) {
            deploymentMetaData.setConnectionUrl(url);
        } else {
            deploymentMetaData.setUseDataSource(true);
            logger.debug((Object)"Creating data source using standard JDBC4 based properties.");
        }
        deploymentMetaData.setDriverClass(dsmd.getClassName());
        deploymentMetaData.setUserName(dsmd.getUser());
        deploymentMetaData.setPassWord(dsmd.getPassword());
        if (dsmd.getIsolationLevel() != null) {
            deploymentMetaData.setTransactionIsolation(dsmd.getIsolationLevel().toString());
        }
        if (dsmd.getMaxStatements() > -1) {
            deploymentMetaData.setPreparedStatementCacheSize(dsmd.getMaxStatements());
        }
        LocalDataSourceDeploymentMetaData cpmd = deploymentMetaData;
        if (dsmd.getMinPoolSize() != -1) {
            cpmd.setMinSize(dsmd.getMinPoolSize());
        }
        if (dsmd.getMaxPoolSize() != -1) {
            cpmd.setMaxSize(dsmd.getMaxPoolSize());
        }
        cpmd.setIdleTimeoutMinutes(dsmd.getMaxIdleTime() / 60);
        if (dsmd.getProperties() != null && dsmd.getProperties().keySet().size() > 0) {
            for (String key : dsmd.getProperties().keySet()) {
                PropertyMetaData pmd = (PropertyMetaData)dsmd.getProperties().get(key);
                connectionProp = new DataSourceConnectionPropertyMetaData();
                connectionProp.setName(pmd.getName());
                connectionProp.setValue(pmd.getValue());
                connectionProps.add(connectionProp);
            }
        }
        return deploymentMetaData;
    }

    private static String normalizeJndiName(String jndiName) {
        if (jndiName != null && jndiName.contains("java:")) {
            return jndiName.replace("java:", "").trim();
        }
        return jndiName;
    }

    static {
        scopes.add("app");
        scopes.add("global");
        scopes.add("module");
        scopes.add("comp");
    }
}

