/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.core.channelfactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.ha.core.channelfactory.ProtocolData;
import org.jboss.ha.core.channelfactory.ProtocolParameter;
import org.jboss.ha.core.channelfactory.ProtocolStackConfigInfo;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolStackUtil {
    private static final Logger log = Logger.getLogger(ProtocolStackUtil.class);
    private static final String PROTOCOL_STACKS = "protocol_stacks";
    private static final String STACK = "stack";
    private static final String NAME = "name";
    private static final String DESCR = "description";
    private static final String CONFIG = "config";

    public static Map<String, ProtocolStackConfigInfo> parse(InputStream input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element configElement = document.getDocumentElement();
        return ProtocolStackUtil.parse(configElement);
    }

    public static Map<String, ProtocolStackConfigInfo> parse(Element root) throws Exception {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        String root_name = root.getNodeName();
        if (!PROTOCOL_STACKS.equals(root_name.trim().toLowerCase())) {
            throw new IOException("Invalid XML configuration: configuration does not start with a 'protocol_stacks' element");
        }
        HashMap<String, ProtocolStackConfigInfo> result = new HashMap<String, ProtocolStackConfigInfo>();
        NodeList tmp_stacks = root.getChildNodes();
        for (int i = 0; i < tmp_stacks.getLength(); ++i) {
            Node node = tmp_stacks.item(i);
            if (node.getNodeType() != 1) continue;
            Element stack = (Element)node;
            String tmp = stack.getNodeName();
            if (!STACK.equals(tmp.trim().toLowerCase())) {
                throw new IOException("Invalid configuration: didn't find a \"stack\" element under \"protocol_stacks\"");
            }
            NamedNodeMap attrs = stack.getAttributes();
            Node name = attrs.getNamedItem(NAME);
            String st_name = name.getNodeValue();
            Node descr = attrs.getNamedItem(DESCR);
            String stack_descr = descr.getNodeValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Parsing \"" + st_name + "\" (" + stack_descr + ")"));
            }
            NodeList configs = stack.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node tmp_config = configs.item(j);
                if (tmp_config.getNodeType() != 1) continue;
                Element cfg = (Element)tmp_config;
                tmp = cfg.getNodeName();
                if (!CONFIG.equals(tmp)) {
                    throw new IOException("Invalid configuration: didn't find a \"config\" element under \"stack\"");
                }
                ProtocolData[] protocolData = ProtocolStackUtil.parseConfig(cfg);
                ProtocolStackUtil.substituteVariables(protocolData);
                result.put(st_name, new ProtocolStackConfigInfo(st_name, stack_descr, protocolData));
            }
        }
        return result;
    }

    public static ProtocolData[] parseSingleConfig(InputStream input) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("null input");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(input);
        Element configElement = document.getDocumentElement();
        return ProtocolStackUtil.parseConfig(configElement);
    }

    public static ProtocolData[] parseConfig(Element root_element) throws IOException {
        LinkedList<ProtocolData> prot_data = new LinkedList<ProtocolData>();
        try {
            String root_name = root_element.getNodeName();
            if (!CONFIG.equals(root_name.trim().toLowerCase())) {
                log.fatal((Object)"XML protocol stack configuration does not start with a '<config>' element; maybe the XML configuration needs to be converted to the new format ?\nuse 'java org.jgroups.conf.XmlConfigurator <old XML file> -new_format' to do so");
                throw new IOException("invalid XML configuration");
            }
            NodeList prots = root_element.getChildNodes();
            for (int i = 0; i < prots.getLength(); ++i) {
                Node node = prots.item(i);
                if (node.getNodeType() != 1) continue;
                Element tag = (Element)node;
                String protocol = tag.getTagName();
                LinkedList<ProtocolParameter> params = new LinkedList<ProtocolParameter>();
                NamedNodeMap attrs = tag.getAttributes();
                int attrLength = attrs.getLength();
                for (int a = 0; a < attrLength; ++a) {
                    Attr attr = (Attr)attrs.item(a);
                    String name = attr.getName();
                    String value = attr.getValue();
                    params.add(new ProtocolParameter(name, value));
                }
                ProtocolData data = new ProtocolData(protocol, protocol, params);
                prot_data.add(data);
            }
            return prot_data.toArray(new ProtocolData[prot_data.size()]);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            throw new IOException(x);
        }
    }

    public static void substituteVariables(ProtocolData[] protocols) {
        for (ProtocolData data : protocols) {
            if (data == null) continue;
            for (ProtocolParameter param : data.getParametersAsArray()) {
                String val = param.getValue();
                String replacement = StringPropertyReplacer.replaceProperties((String)val);
                if (replacement.equals(val)) continue;
                param.setValue(replacement);
            }
        }
    }

    public static String getProtocolStackString(ProtocolData[] protocolData) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < protocolData.length; ++i) {
            ProtocolData pd = protocolData[i];
            buf.append(pd.getProtocolString());
            if (i >= protocolData.length - 1) continue;
            buf.append(':');
        }
        return buf.toString();
    }

    private static List<String> parseProtocols(String config_str) throws IOException {
        LinkedList<String> retval = new LinkedList<String>();
        PushbackReader reader = new PushbackReader(new StringReader(config_str));
        boolean running = true;
        block0: while (running) {
            String protocol_name = ProtocolStackUtil.readWord(reader);
            StringBuilder sb = new StringBuilder();
            sb.append(protocol_name);
            int ch = ProtocolStackUtil.read(reader);
            if (ch == -1) {
                retval.add(sb.toString());
                break;
            }
            if (ch == 58) {
                retval.add(sb.toString());
                continue;
            }
            if (ch == 40) {
                reader.unread(ch);
                String attrs = ProtocolStackUtil.readUntil(reader, ')');
                sb.append(attrs);
                retval.add(sb.toString());
            } else {
                retval.add(sb.toString());
            }
            while ((ch = ProtocolStackUtil.read(reader)) != 58) {
                if (ch != -1) continue;
                running = false;
                continue block0;
            }
        }
        reader.close();
        return retval;
    }

    private static int read(Reader reader) throws IOException {
        int ch = -1;
        while ((ch = reader.read()) != -1) {
            if (Character.isWhitespace(ch)) continue;
            return ch;
        }
        return ch;
    }

    private static String readUntil(Reader reader, char c) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = ProtocolStackUtil.read(reader)) != -1) {
            sb.append((char)ch);
            if (ch != c) continue;
            break;
        }
        return sb.toString();
    }

    private static String readWord(PushbackReader reader) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = ProtocolStackUtil.read(reader)) != -1) {
            if (Character.isLetterOrDigit(ch) || ch == 95 || ch == 46 || ch == 36) {
                sb.append((char)ch);
                continue;
            }
            reader.unread(ch);
            break;
        }
        return sb.toString();
    }

    private static ProtocolData parseProtocol(String protocolConfig) throws Exception {
        String protocol_name = null;
        String properties_str = null;
        int index = protocolConfig.indexOf(40);
        int end_index = protocolConfig.lastIndexOf(41);
        if (index == -1) {
            protocol_name = protocolConfig;
            properties_str = "";
        } else {
            if (end_index == -1) {
                throw new Exception("Configurator.ProtocolConfiguration(): closing ')' not found in " + protocolConfig + ": properties cannot be set !");
            }
            properties_str = protocolConfig.substring(index + 1, end_index);
            protocol_name = protocolConfig.substring(0, index);
        }
        List<ProtocolParameter> params = ProtocolStackUtil.parsePropertiesString(protocol_name, properties_str);
        return new ProtocolData(protocol_name, protocol_name, params);
    }

    private static List<ProtocolParameter> parsePropertiesString(String protocol_name, String properties_str) throws Exception {
        ArrayList<ProtocolParameter> params = new ArrayList<ProtocolParameter>();
        int index = 0;
        if (properties_str.length() > 0) {
            String[] components;
            for (String property : components = properties_str.split(";")) {
                index = property.indexOf(61);
                if (index == -1) {
                    throw new Exception("'=' not found in " + property + " of " + protocol_name);
                }
                String name = property.substring(0, index);
                String value = property.substring(index + 1, property.length());
                params.add(new ProtocolParameter(name, value));
            }
        }
        return params;
    }

    public static ProtocolData[] getProtocolData(Object properties) throws Exception {
        InputStream input = null;
        if (properties == null) {
            properties = "udp.xml";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (input == null && properties instanceof String) {
            try {
                input = new URL((String)properties).openStream();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (input == null && ((String)properties).endsWith("xml")) {
                try {
                    input = Util.getResourceAsStream((String)((String)properties), ConfiguratorFactory.class);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            if (input == null) {
                try {
                    input = new FileInputStream((String)properties);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return ProtocolStackUtil.parseSingleConfig(input);
        }
        if (properties instanceof Element) {
            return ProtocolStackUtil.parseConfig((Element)properties);
        }
        return ProtocolStackUtil.parseProtocolStackString((String)properties);
    }

    private static ProtocolData[] parseProtocolStackString(String configuration) throws Exception {
        ArrayList<ProtocolData> retval = new ArrayList<ProtocolData>();
        List<String> protocol_string = ProtocolStackUtil.parseProtocols(configuration);
        if (protocol_string == null) {
            return null;
        }
        for (String component_string : protocol_string) {
            retval.add(ProtocolStackUtil.parseProtocol(component_string));
        }
        return retval.toArray(new ProtocolData[retval.size()]);
    }

    private ProtocolStackUtil() {
    }
}

