/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reloaded.naming.deployers.mc;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.reloaded.naming.deployers.mc.AbstractNameSpace;
import org.jboss.reloaded.naming.spi.JavaEEApplication;
import org.jboss.reloaded.naming.spi.JavaEEModule;
import org.jboss.util.naming.Util;

public class MCJavaEEModule
extends AbstractNameSpace
implements JavaEEModule {
    private static final Logger log = Logger.getLogger(MCJavaEEModule.class);
    private JavaEEApplication application;

    public MCJavaEEModule(String name, JavaEEApplication application) {
        super(name);
        this.application = application;
    }

    public JavaEEApplication getApplication() {
        return this.application;
    }

    protected String getGlobalName() {
        if (this.getApplication().isEnterpriseApplicationArchive()) {
            return this.getApplication().getName() + "/" + this.name;
        }
        return this.name;
    }

    public void start() throws NamingException {
        super.start();
        Util.createSubcontext((Context)this.getGlobalContext(), (String)this.getGlobalName());
        Util.createSubcontext((Context)this.getApplication().getContext(), (String)this.name);
        this.context.bind("ModuleName", (Object)this.name);
        log.debug((Object)("Installed context " + this.context + " for JavaEE module " + this.name + ", application = " + this.application));
    }

    public void stop() throws NamingException {
        super.stop();
        this.getApplication().getContext().unbind(this.name);
        this.getGlobalContext().unbind(this.getGlobalName());
        log.debug((Object)("Uninstalled context " + this.context + " for JavaEE module " + this.name + ", application = " + this.application));
    }

    public String toString() {
        return "MCJavaEEModule{application=" + this.application + ", name='" + this.name + '\'' + '}';
    }
}

