/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server;

import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.server.AbstractMBeanInvoker;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.TCLAction;
import org.jboss.util.Classes;

public class InvocationContext {
    public static final String OP_INVOKE = "invoke";
    public static final String OP_GETATTRIBUTE = "getAttribute";
    public static final String OP_SETATTRIBUTE = "setAttribute";
    public static final String OP_GETMBEANINFO = "getMBeanInfo";
    public static final String OPERATION_IMPACT = "operation.impact";
    public static final String ATTRIBUTE_ACCESS = "attribute.access";
    private static final Class<?> VOID = Void.class;
    public static final Class<?>[] NOCLASSES = new Class[0];
    private String attributeType = null;
    private String name = null;
    private String[] signature = null;
    private String returnType = null;
    private String type = null;
    private boolean isWritable = true;
    private boolean isReadable = true;
    List interceptors = null;
    transient Interceptor dispatcher = new NullDispatcher();
    transient Object target = null;
    transient Descriptor descriptor = null;
    transient AbstractMBeanInvoker invoker = null;
    transient Class attributeTypeClass = null;
    transient Class returnTypeClass = null;
    transient Class[] signatureClasses = null;

    public final void copy(InvocationContext src) {
        if (src == null) {
            return;
        }
        this.attributeType = src.attributeType;
        this.attributeTypeClass = src.attributeTypeClass;
        this.name = src.name;
        this.signature = src.signature;
        this.signatureClasses = src.signatureClasses;
        this.returnType = src.returnType;
        this.returnTypeClass = src.returnTypeClass;
        this.type = src.type;
        this.isWritable = src.isWritable;
        this.interceptors = src.interceptors;
        this.dispatcher = src.dispatcher;
        this.target = src.target;
        this.descriptor = src.descriptor;
        this.invoker = src.invoker;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void setSignature(String[] signature) {
        this.signature = signature;
    }

    void setSignature(MBeanParameterInfo[] signature) {
        this.signature = new String[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            this.signature[i] = signature[i].getType();
        }
    }

    public String[] getSignature() {
        return this.signature;
    }

    public Class[] getSignatureClasses() throws ClassNotFoundException {
        if (this.signatureClasses != null) {
            return this.signatureClasses;
        }
        if (this.signature == null || this.signature.length == 0) {
            return NOCLASSES;
        }
        Class[] signatureClassesTemp = new Class[this.signature.length];
        for (int i = 0; i < this.signature.length; ++i) {
            signatureClassesTemp[i] = TCLAction.UTIL.getContextClassLoader().loadClass(this.signature[i]);
        }
        this.signatureClasses = signatureClassesTemp;
        return this.signatureClasses;
    }

    public void setAttributeType(String attrType) {
        this.attributeType = attrType;
        this.attributeTypeClass = null;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public Class getAttributeTypeClass() throws ClassNotFoundException {
        if (this.attributeType == null) {
            return null;
        }
        if (this.attributeTypeClass != null) {
            return this.attributeTypeClass;
        }
        this.attributeTypeClass = this.loadClass(this.attributeType);
        return this.attributeTypeClass;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
        this.returnTypeClass = null;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public Class getReturnTypeClass() throws ClassNotFoundException {
        if (this.returnType == null) {
            return null;
        }
        if (this.returnTypeClass == VOID) {
            return null;
        }
        if (this.returnTypeClass != null) {
            return this.returnTypeClass;
        }
        if (this.returnType.equals("void")) {
            this.returnTypeClass = VOID;
            return null;
        }
        this.returnTypeClass = this.loadClass(this.returnType);
        return this.returnTypeClass;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public void setReadable(boolean readable) {
        this.isReadable = readable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public void setWritable(boolean writable) {
        this.isWritable = writable;
    }

    public void setInterceptors(List interceptors) {
        this.interceptors = interceptors;
    }

    public List getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList();
        }
        return this.interceptors;
    }

    public void setDispatcher(Interceptor d) {
        this.dispatcher = d;
    }

    public Interceptor getDispatcher() {
        return this.dispatcher;
    }

    void setTarget(Object o) {
        this.target = o;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setDescriptor(Descriptor d) {
        this.descriptor = d;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setInvoker(AbstractMBeanInvoker mi) {
        this.invoker = mi;
    }

    public MBeanInvoker getInvoker() {
        return this.invoker;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(256);
        sbuf.append("InvocationContext[").append(" name=").append(this.name).append(", type=").append(this.type).append(", attributeType=").append(this.attributeType).append(", isReadable=").append(this.isReadable).append(", isWritable=").append(this.isWritable).append(", returnType=").append(this.returnType);
        if (this.signature != null) {
            sbuf.append(", signature=[");
            for (int i = 0; i < this.signature.length; ++i) {
                sbuf.append(" arg[").append(i).append("]=").append(this.signature[i]);
            }
            sbuf.append(" ] ]");
        } else {
            sbuf.append(", signature=null ]");
        }
        return sbuf.toString();
    }

    private Class loadClass(String clazz) throws ClassNotFoundException {
        Class isPrimitive = Classes.getPrimitiveTypeForName((String)clazz);
        if (isPrimitive != null) {
            return Classes.getPrimitiveWrapper((Class)isPrimitive);
        }
        ClassLoader cl = TCLAction.UTIL.getContextClassLoader();
        return cl.loadClass(clazz);
    }

    class NullDispatcher
    extends AbstractInterceptor {
        public NullDispatcher() {
            super("NullDispatcher");
        }

        public Object invoke(Invocation invocation) throws Throwable {
            return null;
        }
    }
}

