/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.marshalling.NioByteOutput;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.xnio.log.Logger;

final class OutboundRequestBufferWriter
implements NioByteOutput.BufferWriter {
    private final AtomicBoolean first = new AtomicBoolean(true);
    private final int rid;
    private final OutboundRequest outboundRequest;
    private static final Logger log = Loggers.main;

    OutboundRequestBufferWriter(OutboundRequest outboundRequest, int rid) {
        this.outboundRequest = outboundRequest;
        this.rid = rid;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = (ByteBuffer)this.outboundRequest.getRemoteConnectionHandler().getBufferPool().allocate();
        log.trace("Allocated buffer %s for %s", (Object)buffer, (Object)this);
        buffer.putInt(0);
        buffer.put((byte)48);
        buffer.putInt(this.rid);
        boolean isFirst = this.first.getAndSet(false);
        if (isFirst) {
            buffer.put((byte)1);
            buffer.putInt(this.outboundRequest.getClientId());
        } else {
            buffer.put((byte)0);
        }
        log.trace("Prepopulated buffer %s for %s", (Object)buffer, (Object)this);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(ByteBuffer buffer, boolean eof) throws IOException {
        OutboundRequest outboundRequest = this.outboundRequest;
        try {
            outboundRequest.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        RemoteConnectionHandler remoteConnectionHandler = outboundRequest.getRemoteConnectionHandler();
        try {
            if (eof) {
                buffer.put(7, (byte)(buffer.get(3) | 2));
                OutboundRequest outboundRequest2 = outboundRequest;
                synchronized (outboundRequest2) {
                    outboundRequest.setState(OutboundRequest.State.REPLY_WAIT);
                }
            }
            log.trace("Sending buffer %s for %s", (Object)buffer, (Object)this);
            remoteConnectionHandler.getRemoteConnection().sendBlocking(buffer, eof);
        }
        finally {
            remoteConnectionHandler.getBufferPool().free((Object)buffer);
        }
    }

    public void flush() throws IOException {
        this.outboundRequest.getRemoteConnectionHandler().getRemoteConnection().flushBlocking();
    }
}

