/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.config.ConfigurationException;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.util.Proxies;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ModuleProperties
extends Properties {
    private static final long serialVersionUID = 2558131508076199744L;
    private static final Log log = LogFactory.getLog(ModuleProperties.class);
    public static final String MODULE_PROPERTIES_FILENAME = "infinispan-module.properties";
    public static final String MODULE_NAME_KEY = "infinispan.module.name";
    public static final String MODULE_CONFIGURATION_CLASS = "infinispan.module.configurationClassName";
    public static final String MODULE_LIFECYCLE = "infinispan.module.lifecycle";

    protected static Enumeration<URL> getResources(String filename) throws IOException {
        Enumeration<URL> result;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = result = cl == null ? null : cl.getResources(filename);
        if (result == null) {
            result = ModuleProperties.class.getClassLoader().getResources(filename);
        }
        return result;
    }

    public static ModuleProperties loadModuleProperties(String moduleName) throws IOException {
        Enumeration<URL> resources = ModuleProperties.getResources(MODULE_PROPERTIES_FILENAME);
        if (resources == null) {
            throw new IOException("Could not find infinispan-module.properties files on classpath for module " + moduleName);
        }
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            ModuleProperties props = new ModuleProperties();
            props.load(url.openStream());
            props.verify();
            if (!props.getName().equalsIgnoreCase(moduleName)) continue;
            return props;
        }
        return null;
    }

    private static Map<String, ModuleProperties> loadModuleProperties() throws IOException {
        HashMap<String, ModuleProperties> map = new HashMap<String, ModuleProperties>();
        Enumeration<URL> resources = ModuleProperties.getResources(MODULE_PROPERTIES_FILENAME);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = null;
                try {
                    url = resources.nextElement();
                    ModuleProperties props = new ModuleProperties();
                    props.load(url.openStream());
                    props.verify();
                    map.put(props.getName(), props);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not load module at URL " + url), e);
                }
            }
        }
        return map;
    }

    public static List<ModuleLifecycle> resolveModuleLifecycles() throws Exception {
        ArrayList<ModuleLifecycle> lifecycles = new ArrayList<ModuleLifecycle>();
        Map<String, ModuleProperties> p = ModuleProperties.loadModuleProperties();
        for (Map.Entry<String, ModuleProperties> m : p.entrySet()) {
            try {
                String lifecycleClassName = m.getValue().getLifecycleClassName();
                Class loadClass = Util.loadClassStrict(lifecycleClassName);
                Object proxy = Proxies.newCatchThrowableProxy((ModuleLifecycle)loadClass.newInstance());
                ModuleLifecycle ml = (ModuleLifecycle)proxy;
                lifecycles.add(ml);
            }
            catch (Exception e) {
                log.warn((Object)("Module " + m.getKey() + " loaded, but could not be initialized "), e);
            }
        }
        return lifecycles;
    }

    public String getName() {
        return super.getProperty(MODULE_NAME_KEY);
    }

    public String getConfigurationClassName() {
        return super.getProperty(MODULE_CONFIGURATION_CLASS);
    }

    public String getLifecycleClassName() {
        return super.getProperty(MODULE_LIFECYCLE);
    }

    protected void verify() {
        if (this.getName() == null) {
            throw new ConfigurationException("Module properties does not specify module name. Module name should be specified using key infinispan.module.name");
        }
    }
}

