/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.metadata.domain;

import java.util.Stack;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragment;
import org.jboss.profileservice.domain.spi.DomainMetaDataFragmentVisitor;
import org.jboss.profileservice.profile.metadata.BasicSubProfileMetaData;
import org.jboss.profileservice.profile.metadata.domain.RequiredProfiles;
import org.jboss.profileservice.repository.ProfileMetaDataContext;
import org.jboss.profileservice.repository.ProfileMetaDataRepository;
import org.jboss.profileservice.spi.dependency.DependencyMode;
import org.jboss.profileservice.spi.dependency.ProfileCapability;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.spi.dependency.ProfileRequirementResolver;
import org.jboss.profileservice.spi.metadata.ProfileFeatureMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitor;
import org.jboss.profileservice.spi.metadata.ProfileMetaDataVisitorNode;

public class BasicDomainMetaDataVisitor
implements DomainMetaDataFragmentVisitor,
ProfileMetaDataVisitor {
    private final ProfileRequirementResolver resolver;
    private final ProfileMetaDataRepository profileRepository;
    private Stack<String> stack = new Stack();

    public BasicDomainMetaDataVisitor(ProfileRequirementResolver resolver, ProfileMetaDataRepository profileRepository) {
        this.resolver = resolver;
        this.profileRepository = profileRepository;
    }

    public void addProfileMetaData(ProfileMetaData metaData) {
        String profileName = metaData.getName();
        if (profileName == null) {
            throw new IllegalArgumentException("null profile name");
        }
        this.addRequirement((ProfileRequirement)new RequiredProfiles.ResolveRequirement(metaData.getName()));
        ProfileMetaDataContext ctx = this.profileRepository.registerMetaData(metaData);
        this.visit((ProfileMetaDataVisitorNode)metaData);
        if (!this.stack.empty()) {
            String previous = this.stack.pop();
            BasicSubProfileMetaData requirement = new BasicSubProfileMetaData(previous, DependencyMode.OPTIONAL);
            ctx.addRequirement((ProfileRequirement)requirement);
        }
        this.stack.push(profileName);
    }

    public void addAlias(String name) {
    }

    public void addCapability(ProfileCapability capability) {
    }

    public void addRequirement(ProfileRequirement requirement) {
        this.resolver.addRequirement(requirement);
    }

    public void addFeature(ProfileFeatureMetaData feature) {
    }

    public void visit(DomainMetaDataFragment node) {
        node.visit((DomainMetaDataFragmentVisitor)this);
    }

    public void visit(ProfileMetaDataVisitorNode node) {
        node.visit((ProfileMetaDataVisitor)this);
    }
}

