/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment.hotdeploy;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.profileservice.deployment.hotdeploy.AbstractHDScannerFactory;
import org.jboss.profileservice.spi.action.ActionController;

public class DefaultHDScannerFactory
extends AbstractHDScannerFactory {
    private ScheduledExecutorService scanExecutor;
    private ThreadFactory threadFactory;
    private String scanThreadName = "HDScanner";

    public DefaultHDScannerFactory(ActionController actionController) {
        super(actionController);
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public String getScanThreadName() {
        return this.scanThreadName;
    }

    public void setScanThreadName(String scanThreadName) {
        if (scanThreadName == null) {
            throw new IllegalArgumentException("null thread name.");
        }
        this.scanThreadName = scanThreadName;
    }

    public void start() {
        if (this.threadFactory == null) {
            this.threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, DefaultHDScannerFactory.this.getScanThreadName());
                }
            };
        }
        this.scanExecutor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        try {
            this.scanExecutor.shutdownNow();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to cleanly shutdown scanExecutor", (Throwable)e);
        }
        finally {
            this.scanExecutor = null;
        }
    }

    <T extends Runnable> ScheduledFuture schedule(T scanner, int scanPeriod, TimeUnit timeUnit) {
        return this.scanExecutor.scheduleWithFixedDelay(scanner, scanPeriod, scanPeriod, timeUnit);
    }
}

