/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview.attributeview;

import freemind.view.mindmapview.attributeview.AttributeTable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributeTableCellRenderer
extends DefaultTableCellRenderer {
    static final float ZOOM_CORRECTION_FACTOR = 0.97f;
    private boolean isPainting;
    private float zoom;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component rendererComponent = super.getTableCellRendererComponent(table, value, hasFocus, false, row, column);
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        }
        this.zoom = ((AttributeTable)table).getZoom();
        return rendererComponent;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.zoom != 1.0f) {
            this.zoom *= 0.97f;
            AffineTransform transform = g2.getTransform();
            g2.scale(this.zoom, this.zoom);
            this.isPainting = true;
            super.paint(g);
            this.isPainting = false;
            g2.setTransform(transform);
        } else {
            super.paint(g);
        }
    }

    public int getHeight() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)((float)super.getHeight() / this.zoom);
        }
        return super.getHeight();
    }

    public int getWidth() {
        if (this.isPainting && this.zoom != 1.0f) {
            return (int)(0.99f + (float)super.getWidth() / this.zoom);
        }
        return super.getWidth();
    }
}

