/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.menu;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.limewire.core.api.library.LibraryManager;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.warnings.LibraryWarningController;

class AddFileAction
extends AbstractAction {
    private final LibraryManager libraryManager;
    private final LibraryWarningController librarySupport;

    @Inject
    public AddFileAction(LibraryManager libraryManager, LibraryWarningController librarySupport) {
        super(I18n.tr("&Add to Library..."));
        this.libraryManager = libraryManager;
        this.librarySupport = librarySupport;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<File> files = FileChooser.getInput(GuiUtils.getMainFrame(), I18n.tr("Add to Library"), I18n.tr("Add to Library"), FileChooser.getLastInputDirectory(), 2, 0, true, new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || AddFileAction.this.libraryManager.getLibraryData().isFileManageable(f);
            }

            @Override
            public String getDescription() {
                return I18n.tr("Valid Files");
            }
        });
        if (files != null) {
            this.librarySupport.addFiles(this.libraryManager.getLibraryManagedList(), files);
        }
    }
}

