/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class CancelAllErrorDownloadAction
extends AbstractAction {
    private final Provider<DownloadMediator> downloadMediator;

    @Inject
    public CancelAllErrorDownloadAction(Provider<DownloadMediator> downloadMediator) {
        super(I18n.tr("All Error"));
        this.downloadMediator = downloadMediator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.confirmCancellation(I18n.tr("Cancel all error downloads?"))) {
            this.downloadMediator.get().cancelError();
        }
    }

    private boolean confirmCancellation(String message) {
        return FocusJOptionPane.showConfirmDialog(GuiUtils.getMainFrame(), message, I18n.tr("Cancel"), 0, 1) == 0;
    }
}

