/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.statemachine;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.limewire.nio.statemachine.ReadState;

public abstract class SimpleReadState
extends ReadState {
    private final int expect;
    private int amountRead = 0;
    private ByteBuffer buffer;

    public SimpleReadState(int expect) {
        this.expect = expect;
    }

    @Override
    protected boolean processRead(ReadableByteChannel channel, ByteBuffer scratchBuffer) throws IOException {
        if (this.buffer == null) {
            this.buffer = scratchBuffer.slice();
            this.buffer.limit(this.expect);
        }
        int read = 0;
        while (this.buffer.hasRemaining() && (read = channel.read(this.buffer)) > 0) {
            this.amountRead += read;
        }
        if (this.buffer.hasRemaining() && read == -1) {
            throw new IOException("EOF");
        }
        if (!this.buffer.hasRemaining()) {
            this.validateBuffer(this.buffer);
            this.buffer.clear();
            return false;
        }
        return true;
    }

    @Override
    public long getAmountProcessed() {
        return this.amountRead;
    }

    public abstract void validateBuffer(ByteBuffer var1) throws IOException;
}

