/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.NIOSocket;
import org.limewire.nio.observer.AcceptChannelObserver;
import org.limewire.nio.observer.AcceptObserver;
import org.limewire.util.VersionUtils;

public class NIOServerSocket
extends ServerSocket
implements AcceptChannelObserver {
    private static final Log LOG = LogFactory.getLog(NIOServerSocket.class);
    private final ServerSocketChannel channel = ServerSocketChannel.open();
    private final ServerSocket socket = this.channel.socket();
    private final AcceptObserver observer;

    public NIOServerSocket() throws IOException {
        this((AcceptObserver)null);
    }

    public NIOServerSocket(AcceptObserver observer) throws IOException {
        this.init();
        this.observer = observer == null ? new BlockingObserver() : observer;
    }

    public NIOServerSocket(int port) throws IOException {
        this(port, null);
    }

    public NIOServerSocket(int port, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(port));
    }

    public NIOServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, (AcceptObserver)null);
    }

    public NIOServerSocket(int port, int backlog, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(port), backlog);
    }

    public NIOServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this(port, backlog, bindAddr, null);
    }

    public NIOServerSocket(int port, int backlog, InetAddress bindAddr, AcceptObserver observer) throws IOException {
        this(observer);
        this.bind(new InetSocketAddress(bindAddr, port), backlog);
    }

    private void init() throws IOException {
        this.channel.configureBlocking(false);
        this.socket.setReuseAddress(true);
    }

    @Override
    public Socket accept() throws IOException {
        if (this.observer instanceof BlockingObserver) {
            return ((BlockingObserver)this.observer).accept();
        }
        throw new IllegalBlockingModeException();
    }

    @Override
    public void handleAcceptChannel(SocketChannel channel) throws IOException {
        this.observer.handleAccept(this.createClientSocket(channel.socket()));
    }

    @Override
    public void handleIOException(IOException iox) {
        this.observer.handleIOException(iox);
    }

    @Override
    public void shutdown() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.socket.bind(endpoint);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    @Override
    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.socket.bind(endpoint, backlog);
        NIODispatcher.instance().registerAccept(this.channel, this);
    }

    @Override
    public void close() throws IOException {
        IOException exception;
        if (VersionUtils.isJavaVersionOrAbove("1.5.0_10") || NIODispatcher.instance().isDispatchThread()) {
            exception = this.shutdownSocketAndChannels();
        } else {
            Future<IOException> future = NIODispatcher.instance().getScheduledExecutorService().submit(new Callable<IOException>(){

                @Override
                public IOException call() {
                    return NIOServerSocket.this.shutdownSocketAndChannels();
                }
            });
            try {
                exception = future.get();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (ExecutionException ee) {
                throw new IllegalStateException(ee);
            }
        }
        this.observer.shutdown();
        if (exception != null) {
            throw exception;
        }
    }

    private IOException shutdownSocketAndChannels() {
        IOException exception = null;
        try {
            this.socket.close();
        }
        catch (IOException iox) {
            exception = iox;
        }
        return exception;
    }

    protected Socket createClientSocket(Socket socket) {
        return new NIOSocket(socket);
    }

    @Override
    public ServerSocketChannel getChannel() {
        return this.socket.getChannel();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public int getSoTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public String toString() {
        return "NIOServerSocket::" + this.socket.toString();
    }

    private class BlockingObserver
    implements AcceptObserver {
        private final List<Socket> pendingSockets = new LinkedList<Socket>();
        private IOException storedException = null;
        private final Object LOCK = new Object();

        private BlockingObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket accept() throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                boolean looped = false;
                int timeout = NIOServerSocket.this.getSoTimeout();
                while (!NIOServerSocket.this.isClosed() && NIOServerSocket.this.isBound() && this.storedException == null && this.pendingSockets.isEmpty()) {
                    if (looped && timeout != 0) {
                        throw new SocketTimeoutException("accept timed out: " + timeout);
                    }
                    LOG.debug("Waiting for incoming socket...");
                    try {
                        this.LOCK.wait(timeout);
                    }
                    catch (InterruptedException ix) {
                        throw new InterruptedIOException(ix);
                    }
                    looped = true;
                }
                IOException x = this.storedException;
                this.storedException = null;
                if (NIOServerSocket.this.isClosed()) {
                    throw new SocketException("Socket Closed");
                }
                if (x != null) {
                    throw x;
                }
                if (!NIOServerSocket.this.isBound()) {
                    throw new SocketException("Not Bound!");
                }
                LOG.debug("Retrieved a socket!");
                return this.pendingSockets.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleAccept(Socket socket) throws IOException {
            Object object = this.LOCK;
            synchronized (object) {
                this.pendingSockets.add(socket);
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleIOException(IOException iox) {
            Object object = this.LOCK;
            synchronized (object) {
                this.storedException = iox;
                this.LOCK.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            Object object = this.LOCK;
            synchronized (object) {
                for (Socket next : this.pendingSockets) {
                    try {
                        next.close();
                    }
                    catch (IOException ignored) {}
                }
                this.pendingSockets.clear();
                this.LOCK.notify();
            }
        }
    }
}

