/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.ResponseHandler;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StoreRequest;
import org.limewire.mojito.messages.StoreResponse;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.settings.StoreSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.security.SecurityToken;

public class StoreResponseHandler
extends AbstractResponseHandler<StoreResult> {
    private static final Log LOG = LogFactory.getLog(StoreResponseHandler.class);
    private final Collection<? extends DHTValueEntity> entities;
    private final List<StoreProcess> processes = new ArrayList<StoreProcess>();
    private Iterator<StoreProcess> toProcess = null;
    private Map<KUID, StoreProcess> activeProcesses = new HashMap<KUID, StoreProcess>();
    private final int parallelism = StoreSettings.PARALLEL_STORES.getValue();

    public StoreResponseHandler(Context context, Collection<? extends Map.Entry<? extends Contact, ? extends SecurityToken>> path, Collection<? extends DHTValueEntity> entities) {
        super(context);
        this.entities = entities;
        if (path.size() > KademliaSettings.REPLICATION_PARAMETER.getValue() && LOG.isWarnEnabled()) {
            LOG.warn("Path is longer than K: " + path.size() + " > " + KademliaSettings.REPLICATION_PARAMETER.getValue());
        }
        for (Map.Entry<? extends Contact, ? extends SecurityToken> entry : path) {
            Contact node = entry.getKey();
            SecurityToken securityToken = entry.getValue();
            if (context.isLocalNode(node)) {
                this.processes.add(new LocalStoreProcess(node, securityToken, entities));
                continue;
            }
            this.processes.add(new RemoteStoreProcess(node, securityToken, entities));
        }
    }

    @Override
    public void start() throws DHTException {
        this.toProcess = this.processes.iterator();
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        Contact node = message.getContact();
        KUID nodeId = node.getNodeID();
        StoreProcess process = this.activeProcesses.get(nodeId);
        if (process != null && process.response(message)) {
            this.activeProcesses.remove(nodeId);
        }
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        StoreProcess process = this.activeProcesses.get(nodeId);
        if (process != null && process.timeout(message, time)) {
            this.activeProcesses.remove(nodeId);
        }
        this.sendNextAndExitIfDone();
    }

    @Override
    protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        StoreProcess process = this.activeProcesses.get(nodeId);
        if (process != null && process.error(message, e)) {
            this.activeProcesses.remove(nodeId);
        }
        this.sendNextAndExitIfDone();
    }

    private void sendNextAndExitIfDone() {
        while (this.activeProcesses.size() < this.parallelism && this.toProcess.hasNext()) {
            StoreProcess process = this.toProcess.next();
            try {
                boolean done = process.store();
                if (done) continue;
                Contact node = process.getContact();
                this.activeProcesses.put(node.getNodeID(), process);
            }
            catch (IOException err) {
                process.setIOException(err);
                process.finish();
                LOG.error("IOException", err);
            }
        }
        if (this.activeProcesses.isEmpty()) {
            this.done();
        }
    }

    private void done() {
        LinkedHashMap<Contact, Collection<StoreResponse.StoreStatusCode>> map = new LinkedHashMap<Contact, Collection<StoreResponse.StoreStatusCode>>();
        HashMap<KUID, ArrayList<Contact>> locations = new HashMap<KUID, ArrayList<Contact>>();
        for (StoreProcess process : this.processes) {
            Contact node = process.getContact();
            Collection<StoreResponse.StoreStatusCode> statusCodes = process.getStoreStatusCodes();
            map.put(node, statusCodes);
            for (StoreResponse.StoreStatusCode statusCode : statusCodes) {
                if (!statusCode.getStatusCode().equals(StoreResponse.OK)) continue;
                KUID secondaryKey = statusCode.getSecondaryKey();
                ArrayList<Contact> nodes = (ArrayList<Contact>)locations.get(secondaryKey);
                if (nodes == null) {
                    nodes = new ArrayList<Contact>();
                    locations.put(secondaryKey, nodes);
                }
                nodes.add(node);
            }
        }
        if (this.processes.size() == 1) {
            StoreProcess process = this.processes.get(0);
            IOException exception = process.getIOException();
            long timeout = process.getTimeout();
            if (exception != null) {
                this.setException(new DHTException(exception));
                return;
            }
            if (timeout != -1L) {
                Contact node = process.getContact();
                KUID nodeId = node.getNodeID();
                SocketAddress dst = node.getContactAddress();
                this.fireTimeoutException(nodeId, dst, null, timeout);
                return;
            }
        }
        StoreResult result = new StoreResult(map, this.entities);
        this.setReturnValue(result);
    }

    private class RemoteStoreProcess
    extends StoreProcess {
        private DHTValueEntity currentEntity;

        private RemoteStoreProcess(Contact node, SecurityToken securityToken, Collection<? extends DHTValueEntity> entities) {
            super(node, securityToken, entities);
            this.currentEntity = null;
        }

        @Override
        public boolean store() throws IOException {
            this.currentEntity = null;
            if (!this.hasNext()) {
                return true;
            }
            this.currentEntity = this.next();
            StoreRequest request = StoreResponseHandler.this.context.getMessageHelper().createStoreRequest(this.getContact().getContactAddress(), this.getSecurityToken(), Collections.singleton(this.currentEntity));
            StoreResponseHandler.this.context.getMessageDispatcher().send(this.getContact(), (RequestMessage)request, (ResponseHandler)StoreResponseHandler.this);
            return false;
        }

        @Override
        public boolean response(ResponseMessage msg) throws IOException {
            StoreResponse response = (StoreResponse)msg;
            Collection<StoreResponse.StoreStatusCode> codes = response.getStoreStatusCodes();
            if (codes.size() != 1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(this.getContact() + " sent a wrong number of StoreStatusCodes: " + codes);
                }
                this.finish();
                return true;
            }
            StoreResponse.StoreStatusCode code = codes.iterator().next();
            if (!code.isFor(this.currentEntity)) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(this.getContact() + " sent a wrong [" + code + "] for " + this.currentEntity + "\n" + CollectionUtils.toString(this.getEntities()));
                }
                this.finish();
                return true;
            }
            return this.store();
        }

        @Override
        public boolean error(RequestMessage msg, IOException err) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Couldn't store " + this.currentEntity + " at " + this.getContact(), err);
            }
            this.setIOException(err);
            this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
            try {
                return this.store();
            }
            catch (IOException iox) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("IOException", iox);
                }
                this.finish();
                return true;
            }
        }

        @Override
        public boolean timeout(RequestMessage msg, long timeout) throws IOException {
            if (LOG.isInfoEnabled()) {
                LOG.info("Couldn't store " + this.currentEntity + " at " + this.getContact());
            }
            this.setTimeout(timeout);
            this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
            return this.store();
        }

        @Override
        public void finish() {
            if (this.currentEntity != null) {
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(this.currentEntity, StoreResponse.ERROR));
                this.currentEntity = null;
            }
            super.finish();
        }
    }

    private class LocalStoreProcess
    extends StoreProcess {
        private LocalStoreProcess(Contact node, SecurityToken securityToken, Collection<? extends DHTValueEntity> entities) {
            super(node, securityToken, entities);
        }

        @Override
        public boolean store() throws IOException {
            Database database = StoreResponseHandler.this.context.getDatabase();
            while (this.hasNext()) {
                DHTValueEntity entity = this.next();
                boolean stored = database.store(entity);
                if (stored) {
                    this.addStoreStatusCode(new StoreResponse.StoreStatusCode(entity, StoreResponse.OK));
                    continue;
                }
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(entity, StoreResponse.ERROR));
            }
            return true;
        }

        @Override
        public boolean response(ResponseMessage msg) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean error(RequestMessage msg, IOException err) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean timeout(RequestMessage msg, long time) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class StoreProcess {
        private final Contact node;
        private final SecurityToken securityToken;
        private final Collection<? extends DHTValueEntity> entities;
        private final Iterator<? extends DHTValueEntity> iterator;
        private final Collection<StoreResponse.StoreStatusCode> codes = new ArrayList<StoreResponse.StoreStatusCode>();
        private IOException exception;
        private long timeout = -1L;

        private StoreProcess(Contact node, SecurityToken securityToken, Collection<? extends DHTValueEntity> entities) {
            this.node = node;
            this.securityToken = securityToken;
            this.entities = entities;
            this.iterator = entities.iterator();
        }

        public Contact getContact() {
            return this.node;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }

        public Collection<? extends DHTValueEntity> getEntities() {
            return this.entities;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public DHTValueEntity next() {
            return this.iterator.next();
        }

        public void addStoreStatusCode(StoreResponse.StoreStatusCode code) {
            this.codes.add(code);
        }

        public Collection<StoreResponse.StoreStatusCode> getStoreStatusCodes() {
            return this.codes;
        }

        public void setIOException(IOException exception) {
            this.exception = exception;
        }

        public IOException getIOException() {
            return this.exception;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void finish() {
            while (this.hasNext()) {
                DHTValueEntity entity = this.next();
                this.addStoreStatusCode(new StoreResponse.StoreStatusCode(entity, StoreResponse.ERROR));
            }
        }

        public abstract boolean store() throws IOException;

        public abstract boolean response(ResponseMessage var1) throws IOException;

        public abstract boolean error(RequestMessage var1, IOException var2);

        public abstract boolean timeout(RequestMessage var1, long var2) throws IOException;
    }
}

