/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.Provider;
import java.io.IOException;
import java.net.Socket;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.ReapingClientConnectionManager;
import org.limewire.http.httpclient.SocketWrappingHttpClient;

class LimeHttpClientImpl
extends DefaultHttpClient
implements SocketWrappingHttpClient {
    private Credentials credentials;

    @Override
    public void setSocket(Socket socket) {
        ((ReapingClientConnectionManager)this.getConnectionManager()).setSocket(socket);
    }

    @Override
    public void releaseConnection(HttpResponse response) {
        this.close(response);
    }

    public LimeHttpClientImpl(ReapingClientConnectionManager manager, Provider<HttpParams> defaultParams) {
        super(manager, defaultParams.get());
    }

    @Override
    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new HttpRequestRetryHandler(){

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return false;
            }
        };
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    protected CredentialsProvider createCredentialsProvider() {
        return new CredentialsProvider(){

            @Override
            public void setCredentials(AuthScope authscope, Credentials credentials) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Credentials getCredentials(AuthScope authscope) {
                return LimeHttpClientImpl.this.credentials;
            }

            @Override
            public void clear() {
                LimeHttpClientImpl.this.credentials = null;
            }
        };
    }

    private void close(HttpResponse response) {
        HttpClientUtils.releaseConnection(response);
    }
}

