/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnectionFactory;
import org.limewire.friend.api.FriendConnectionFactoryRegistry;
import org.limewire.friend.api.FriendManager;
import org.limewire.friend.api.MutableFriendManager;
import org.limewire.friend.impl.DefaultFriendAuthenticator;
import org.limewire.friend.impl.FriendConnectionFactoryRegistryImpl;
import org.limewire.friend.impl.FriendInspections;
import org.limewire.friend.impl.MutableFriendManagerImpl;
import org.limewire.friend.impl.SessionTimeListener;
import org.limewire.friend.impl.feature.AuthTokenRegistry;
import org.limewire.friend.impl.feature.LimeWireFriendFeatureModule;

public class LimeWireFriendImplModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new LimeWireFriendFeatureModule());
        this.bind(FriendConnectionFactoryRegistry.class).to(FriendConnectionFactoryRegistryImpl.class);
        this.bind(FriendConnectionFactory.class).to(FriendConnectionFactoryRegistryImpl.class);
        this.bind(FriendManager.class).to(MutableFriendManagerImpl.class);
        this.bind(MutableFriendManager.class).to(MutableFriendManagerImpl.class);
        this.bind(AuthTokenRegistry.class).to(DefaultFriendAuthenticator.class).asEagerSingleton();
        this.bind(FriendInspections.class);
        this.bind(SessionTimeListener.class);
    }

    @Provides
    @Named(value="known")
    Collection<Friend> knownFriendsList(@Named(value="known") Map<String, Friend> friends) {
        return friends.values();
    }

    @Provides
    @Named(value="available")
    Collection<Friend> availableFriendsList(@Named(value="available") Map<String, Friend> friends) {
        return friends.values();
    }

    @Provides
    @Named(value="availableFriendIds")
    Set<String> availableFriendIds(MutableFriendManagerImpl friendManager) {
        return friendManager.getAvailableFriendIds();
    }

    @Provides
    @Named(value="available")
    Map<String, Friend> availableFriends(MutableFriendManagerImpl friendManager) {
        return friendManager.getAvailableFriends();
    }

    @Provides
    @Named(value="known")
    Map<String, Friend> knownFriends(MutableFriendManagerImpl friendManager) {
        return friendManager.getKnownFriends();
    }
}

