/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.activation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.limewire.activation.api.ActivationItem;

class ActivationResponse {
    private final String jsonString;
    private final String lid;
    private final String mcode;
    private final String token;
    private final int refreshMinutes;
    private final List<ActivationItem> activationItems;
    private final Type type;
    private final String message;

    public ActivationResponse(String jsonString, String lid, Type type, String mcode, String token, int refreshMinutes, List<ActivationItem> activationItems, String message) {
        this.jsonString = jsonString;
        this.lid = lid;
        this.type = type;
        this.mcode = mcode;
        this.token = token;
        this.refreshMinutes = refreshMinutes;
        this.activationItems = Collections.unmodifiableList(new ArrayList<ActivationItem>(activationItems));
        this.message = message;
    }

    public String getJSONString() {
        return this.jsonString;
    }

    public String getLid() {
        return this.lid;
    }

    boolean isValidResponse() {
        return this.type == Type.VALID;
    }

    public Type getResponseType() {
        return this.type;
    }

    public String getMCode() {
        return this.mcode;
    }

    public String getToken() {
        return this.token;
    }

    public int getRefreshIntervalInMinutes() {
        return this.refreshMinutes;
    }

    public List<ActivationItem> getActivationItems() {
        return this.activationItems;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum Type {
        VALID,
        NOTFOUND,
        BLOCKED,
        ERROR,
        REMOVE,
        STOP;

    }
}

