/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.util.Cache;
import org.jivesoftware.smack.util.DirContextFactory;

public class DNSUtil {
    private static final Log LOG = LogFactory.getLog(DNSUtil.class);
    private static Map<String, HostAddress> cache = new Cache<String, HostAddress>(100, 600000L);

    public static HostAddress resolveXMPPDomain(String domain) throws NamingException {
        HostAddress address;
        DirContext context = DirContextFactory.getContext();
        String key = "c" + domain;
        if (cache.containsKey(key) && (address = cache.get(key)) != null) {
            return address;
        }
        Attributes dnsLookup = context.getAttributes("_xmpp-client._tcp." + domain, new String[]{"SRV"});
        String srvRecord = (String)dnsLookup.get("SRV").get();
        String[] srvRecordEntries = srvRecord.split(" ");
        int port = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
        String host = srvRecordEntries[srvRecordEntries.length - 1];
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        HostAddress address2 = new HostAddress(host, port);
        cache.put(key, address2);
        context.close();
        return address2;
    }

    public static HostAddress resolveXMPPServerDomain(String domain) throws NamingException {
        String host;
        int port;
        HostAddress address;
        DirContext context = DirContextFactory.getContext();
        String key = "s" + domain;
        if (cache.containsKey(key) && (address = cache.get(key)) != null) {
            return address;
        }
        try {
            Attributes dnsLookup = context.getAttributes("_xmpp-server._tcp." + domain, new String[]{"SRV"});
            String srvRecord = (String)dnsLookup.get("SRV").get();
            String[] srvRecordEntries = srvRecord.split(" ");
            port = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
            host = srvRecordEntries[srvRecordEntries.length - 1];
        }
        catch (NamingException e) {
            LOG.error(e.getMessage(), e);
            Attributes dnsLookup = context.getAttributes("_jabber._tcp." + domain, new String[]{"SRV"});
            String srvRecord = (String)dnsLookup.get("SRV").get();
            String[] srvRecordEntries = srvRecord.split(" ");
            port = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
            host = srvRecordEntries[srvRecordEntries.length - 1];
        }
        if (host.endsWith(".")) {
            host = host.substring(0, host.length() - 1);
        }
        HostAddress address2 = new HostAddress(host, port);
        cache.put(key, address2);
        context.close();
        return address2;
    }

    public static class HostAddress {
        private String host;
        private int port;

        public HostAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HostAddress)) {
                return false;
            }
            HostAddress address = (HostAddress)o;
            if (!this.host.equals(address.host)) {
                return false;
            }
            return this.port == address.port;
        }
    }
}

