/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.transitions;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ComponentState {
    private JComponent component;
    private int x;
    private int y;
    private int width;
    private int height;
    private Image componentSnapshot;

    ComponentState() {
    }

    public ComponentState(JComponent component) {
        this.component = component;
        this.x = component.getX();
        this.y = component.getY();
        this.width = component.getWidth();
        this.height = component.getHeight();
        this.componentSnapshot = this.createSnapshot(component);
    }

    private Image createSnapshot(JComponent component) {
        GraphicsConfiguration gc = component.getGraphicsConfiguration();
        if (gc == null) {
            gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (this.width != 0 && this.height != 0) {
            BufferedImage snapshot = gc.createCompatibleImage(this.width, this.height, component.isOpaque() ? 1 : 3);
            Graphics2D gImg = (Graphics2D)((Image)snapshot).getGraphics();
            ComponentState.paintSingleBuffered(component, gImg);
            gImg.dispose();
            return snapshot;
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Image getSnapshot() {
        if (this.componentSnapshot == null) {
            this.componentSnapshot = this.createSnapshot(this.component);
        }
        return this.componentSnapshot;
    }

    public static void paintSingleBuffered(JComponent component, Graphics g) {
        component.print(g);
    }

    public static void paintHierarchySingleBuffered(JComponent component, Graphics g) {
        int x = 0;
        int y = 0;
        int w = component.getWidth();
        int h = component.getHeight();
        JComponent topmost = component;
        JComponent prevTopmost = component;
        while (!topmost.isOpaque() && topmost.getParent() != null && topmost.getParent() instanceof JComponent) {
            topmost = (JComponent)topmost.getParent();
            x += prevTopmost.getX();
            y += prevTopmost.getY();
            prevTopmost = topmost;
        }
        g.setClip(0, 0, w, h);
        g.translate(-x, -y);
        topmost.print(g);
        ComponentState.paintSingleBuffered(topmost, g);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ComponentState) {
            ComponentState other = (ComponentState)obj;
            if (this.x == other.x && this.y == other.y && this.width == other.width && this.height == other.height && this.component == other.component) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.x;
        result = 37 * result + this.y;
        result = 37 * result + this.width;
        result = 37 * result + this.height;
        result = 37 * result + this.component.hashCode();
        return result;
    }

    public String toString() {
        return "ComponentState: x, y, w, h, component = " + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ", " + this.component;
    }
}

