/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class FlacStreamReader {
    public static final int FLAC_STREAM_IDENTIFIER_LENGTH = 4;
    public static final String FLAC_STREAM_IDENTIFIER = "fLaC";
    private RandomAccessFile raf;
    private int startOfFlacInFile;

    public FlacStreamReader(RandomAccessFile raf) {
        this.raf = raf;
    }

    public void findStream() throws IOException, CannotReadException {
        if (this.raf.length() == 0L) {
            throw new CannotReadException("Error: File empty");
        }
        this.raf.seek(0L);
        if (this.isFlacHeader()) {
            this.startOfFlacInFile = 0;
            return;
        }
        if (this.isId3v24Tag()) {
            this.startOfFlacInFile = (int)(this.raf.getFilePointer() - 4L);
            return;
        }
        if (this.isId3v23Tag()) {
            this.startOfFlacInFile = (int)(this.raf.getFilePointer() - 4L);
            return;
        }
        if (this.isId3v22Tag()) {
            this.startOfFlacInFile = (int)(this.raf.getFilePointer() - 4L);
            return;
        }
        throw new CannotReadException(ErrorMessage.FLAC_NO_FLAC_HEADER_FOUND.getMsg());
    }

    private boolean isId3v24Tag() throws IOException {
        int id3tagsize = 0;
        ID3v24Tag id3tag = new ID3v24Tag();
        ByteBuffer bb = ByteBuffer.allocate(10);
        this.raf.seek(0L);
        this.raf.getChannel().read(bb);
        if (id3tag.seek(bb)) {
            id3tagsize = id3tag.readSize(bb);
            this.raf.seek(id3tagsize);
            if (this.isFlacHeader()) {
                return true;
            }
        }
        return false;
    }

    private boolean isId3v23Tag() throws IOException {
        int id3tagsize = 0;
        ID3v23Tag id3tag = new ID3v23Tag();
        ByteBuffer bb = ByteBuffer.allocate(10);
        this.raf.seek(0L);
        this.raf.getChannel().read(bb);
        if (id3tag.seek(bb)) {
            id3tagsize = id3tag.readSize(bb);
            this.raf.seek(id3tagsize);
            if (this.isFlacHeader()) {
                return true;
            }
        }
        return false;
    }

    private boolean isId3v22Tag() throws IOException {
        int id3tagsize = 0;
        ID3v22Tag id3tag = new ID3v22Tag();
        ByteBuffer bb = ByteBuffer.allocate(10);
        this.raf.seek(0L);
        this.raf.getChannel().read(bb);
        if (id3tag.seek(bb)) {
            id3tagsize = id3tag.readSize(bb);
            this.raf.seek(id3tagsize);
            if (this.isFlacHeader()) {
                return true;
            }
        }
        return false;
    }

    private boolean isFlacHeader() throws IOException {
        byte[] b = new byte[4];
        this.raf.read(b);
        String flac = new String(b);
        return flac.equals(FLAC_STREAM_IDENTIFIER);
    }

    public int getStartOfFlacInFile() {
        return this.startOfFlacInFile;
    }
}

