/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.EncryptionChunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

class EncryptionChunkReader
implements ChunkReader {
    protected EncryptionChunkReader() {
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID getApplyingId() {
        return GUID.GUID_CONTENT_ENCRYPTION;
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        EncryptionChunk result = null;
        BigInteger chunkLen = Utils.readBig64(stream);
        result = new EncryptionChunk(chunkLen);
        int fieldLength = 0;
        fieldLength = (int)Utils.readUINT32(stream);
        byte[] secretData = new byte[fieldLength + 1];
        stream.read(secretData, 0, fieldLength);
        secretData[fieldLength] = 0;
        fieldLength = 0;
        fieldLength = (int)Utils.readUINT32(stream);
        byte[] protectionType = new byte[fieldLength + 1];
        stream.read(protectionType, 0, fieldLength);
        protectionType[fieldLength] = 0;
        fieldLength = 0;
        fieldLength = (int)Utils.readUINT32(stream);
        byte[] keyID = new byte[fieldLength + 1];
        stream.read(keyID, 0, fieldLength);
        keyID[fieldLength] = 0;
        fieldLength = 0;
        fieldLength = (int)Utils.readUINT32(stream);
        byte[] licenseURL = new byte[fieldLength + 1];
        stream.read(licenseURL, 0, fieldLength);
        licenseURL[fieldLength] = 0;
        result.setSecretData(new String(secretData));
        result.setProtectionType(new String(protectionType));
        result.setKeyID(new String(keyID));
        result.setLicenseURL(new String(licenseURL));
        result.setPosition(chunkStart);
        return result;
    }
}

