/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkHeaderReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.io.CountingInputStream;
import org.jaudiotagger.audio.asf.util.Utils;

abstract class ChunkContainerReader<ChunkType extends ChunkContainer>
implements ChunkReader {
    public static final int READ_LIMIT = 8192;
    protected final boolean eachChunkOnce;
    protected boolean hasFailingReaders = false;
    protected final HashMap<GUID, ChunkReader> readerMap = new HashMap();

    protected ChunkContainerReader(List<Class<? extends ChunkReader>> toRegister, boolean readChunkOnce) {
        this.eachChunkOnce = readChunkOnce;
        for (Class<? extends ChunkReader> curr : toRegister) {
            this.register(curr);
        }
    }

    @Override
    public boolean canFail() {
        return false;
    }

    protected void checkStream(InputStream stream) throws IllegalArgumentException {
        if (this.hasFailingReaders && !stream.markSupported()) {
            throw new IllegalArgumentException("Stream has to support mark/reset.");
        }
    }

    protected abstract ChunkType createContainer(long var1, BigInteger var3, InputStream var4) throws IOException;

    protected ChunkReader getReader(GUID guid) {
        return this.readerMap.get(guid);
    }

    protected boolean isReaderAvailable(GUID guid) {
        return this.readerMap.containsKey(guid);
    }

    public ChunkType read(GUID guid, InputStream stream, long chunkStart) throws IOException, IllegalArgumentException {
        this.checkStream(stream);
        CountingInputStream cis = new CountingInputStream(stream);
        if (!this.getApplyingId().equals(guid)) {
            throw new IllegalArgumentException("provided GUID is not supported by this reader.");
        }
        BigInteger chunkLen = Utils.readBig64(cis);
        ChunkType result = this.createContainer(chunkStart, chunkLen, cis);
        long currentPosition = chunkStart + cis.getReadCount() + 16L;
        HashSet<GUID> alreadyRead = new HashSet<GUID>();
        while (currentPosition < ((Chunk)result).getChunckEnd()) {
            Chunk chunk;
            boolean skip;
            GUID currentGUID = Utils.readGUID(cis);
            boolean bl = skip = this.eachChunkOnce && (!this.isReaderAvailable(currentGUID) || !alreadyRead.add(currentGUID));
            if (!skip && this.isReaderAvailable(currentGUID)) {
                ChunkReader reader = this.getReader(currentGUID);
                if (reader.canFail()) {
                    cis.mark(8192);
                }
                chunk = this.getReader(currentGUID).read(currentGUID, cis, currentPosition);
            } else {
                chunk = new ChunkHeaderReader().read(currentGUID, cis, currentPosition);
            }
            if (chunk != null) {
                if (!skip) {
                    ((ChunkContainer)result).addChunk(chunk);
                }
                currentPosition = chunk.getChunckEnd();
                assert (cis.getReadCount() + chunkStart + 16L == currentPosition);
                continue;
            }
            cis.reset();
        }
        return result;
    }

    private <T extends ChunkReader> void register(Class<T> toRegister) {
        try {
            ChunkReader reader = (ChunkReader)toRegister.newInstance();
            this.readerMap.put(reader.getApplyingId(), reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

