/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.codecs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.nio.codecs.AbstractContentEncoder;
import org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.http.nio.util.BufferInfo;
import org.apache.http.util.CharArrayBuffer;

public class ChunkEncoder
extends AbstractContentEncoder {
    private final CharArrayBuffer lineBuffer = new CharArrayBuffer(16);
    private final BufferInfo bufferinfo;

    public ChunkEncoder(WritableByteChannel channel, SessionOutputBuffer buffer, HttpTransportMetricsImpl metrics) {
        super(channel, buffer, metrics);
        this.bufferinfo = buffer instanceof BufferInfo ? (BufferInfo)((Object)buffer) : null;
    }

    public int write(ByteBuffer src) throws IOException {
        int avail;
        if (src == null) {
            return 0;
        }
        this.assertNotCompleted();
        int chunk = src.remaining();
        if (chunk == 0) {
            return 0;
        }
        long bytesWritten = this.buffer.flush(this.channel);
        if (bytesWritten > 0L) {
            this.metrics.incrementBytesTransferred(bytesWritten);
        }
        if ((avail = this.bufferinfo != null ? this.bufferinfo.available() : 4096) == 0) {
            return 0;
        }
        if ((avail -= 10) < chunk) {
            this.lineBuffer.clear();
            this.lineBuffer.append(Integer.toHexString(avail));
            this.buffer.writeLine(this.lineBuffer);
            int oldlimit = src.limit();
            src.limit(src.position() + avail);
            this.buffer.write(src);
            src.limit(oldlimit);
        } else {
            this.lineBuffer.clear();
            this.lineBuffer.append(Integer.toHexString(chunk));
            this.buffer.writeLine(this.lineBuffer);
            this.buffer.write(src);
        }
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer);
        return chunk;
    }

    public void complete() throws IOException {
        this.assertNotCompleted();
        this.lineBuffer.clear();
        this.lineBuffer.append("0");
        this.buffer.writeLine(this.lineBuffer);
        this.lineBuffer.clear();
        this.buffer.writeLine(this.lineBuffer);
        this.completed = true;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[chunk-coded; completed: ");
        buffer.append(this.completed);
        buffer.append("]");
        return buffer.toString();
    }
}

