/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.qt.media.content.unknown;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.protocol.DataSource;
import net.sf.fmj.concurrent.ExecutorServiceManager;
import net.sf.fmj.ejmf.toolkit.media.AbstractPlayer;
import net.sf.fmj.gui.controlpanelfactory.ControlPanelFactorySingleton;
import net.sf.fmj.qt.media.content.unknown.RococoaGainControl;
import net.sf.fmj.utility.ExceptionUtils;
import net.sf.fmj.utility.LoggerSingleton;
import org.rococoa.ObjCObject;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.Rococoa;
import org.rococoa.cocoa.foundation.NSArray;
import org.rococoa.cocoa.qtkit.MovieComponent;
import org.rococoa.cocoa.qtkit.QTKit;
import org.rococoa.cocoa.qtkit.QTMovie;
import org.rococoa.cocoa.qtkit.QTMovieView;
import org.rococoa.cocoa.qtkit.QTTime;
import org.rococoa.cocoa.qtkit.QTTrack;

public class JavaToCocoaHandler
extends AbstractPlayer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final ExecutorService executorService = ExecutorServiceManager.getExecutorService();
    private boolean prefetchNeeded = true;
    private static final boolean TRACE = false;
    private QTMovie movie;
    private MovieComponent movieComponent;
    private QTMovieView movieView;
    private QTTime readPositionInMedia;
    private int timeScale = -1;

    public void createNewMovieFromURL(String theURL) throws IncompatibleSourceException {
        logger.fine(theURL);
        String path = theURL.replace("file:///", "");
        this.movieView = QTMovieView.CLASS.create();
        this.movieView.setControllerVisible(false);
        this.movieView.setPreservesAspectRatio(true);
        this.movieComponent = new MovieComponent(this.movieView);
        ObjCObjectByReference errorReference = new ObjCObjectByReference();
        this.movie = QTMovie.movieWithFile_error((String)path, (ObjCObjectByReference)errorReference);
        if (this.movie == null) {
            throw new IncompatibleSourceException("The movie " + path + " could not be opened in the Cocoa QuickTime Player.");
        }
        this.movieView.setMovie(this.movie);
        this.movie.gotoBeginning();
        NSArray audioTracks = this.movie.tracksOfMediaType("soun");
        if (audioTracks != null && audioTracks.count() > 0) {
            QTTrack track = (QTTrack)Rococoa.cast((ObjCObject)this.movie.tracksOfMediaType("soun").objectAtIndex(0), QTTrack.class);
            this.setGainControl(new RococoaGainControl(track));
        }
        this.movie.play();
    }

    private void registerStopTriggerNotification() {
    }

    public void setSource(final DataSource source) throws IncompatibleSourceException {
        Future<Void> future = executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws IncompatibleSourceException {
                if (JavaToCocoaHandler.this.movie != null) {
                    JavaToCocoaHandler.this.movie.stop();
                }
                JavaToCocoaHandler.this.createNewMovieFromURL(source.getLocator().toExternalForm());
                JavaToCocoaHandler.super.setSource(source);
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void doPlayerClose() {
        logger.info("RococoaHandler.doPlayerClose");
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                if (JavaToCocoaHandler.this.movie != null) {
                    JavaToCocoaHandler.this.movie.stop();
                }
            }
        });
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public boolean doPlayerDeallocate() {
        logger.info("RococoaHandler.doPlayerDeallocate");
        if (this.movieComponent != null) {
            this.movieComponent = null;
        }
        if (this.movie != null) {
            this.movie = null;
        }
        if (this.movieView != null) {
            this.movieView = null;
        }
        if (this.readPositionInMedia != null) {
            this.readPositionInMedia = null;
        }
        return true;
    }

    public boolean doPlayerPrefetch() {
        if (!this.prefetchNeeded) {
            return true;
        }
        this.prefetchNeeded = false;
        return true;
    }

    public boolean doPlayerRealize() {
        return true;
    }

    public synchronized void doPlayerSetMediaTime(final Time t) {
        this.readPositionInMedia = new QTTime((long)(t.getSeconds() * (double)this.timeScale), this.timeScale);
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                if (JavaToCocoaHandler.this.timeScale == -1) {
                    QTTime currentTime = JavaToCocoaHandler.this.movie.currentTime();
                    JavaToCocoaHandler.this.timeScale = currentTime.timeScale.intValue();
                }
                JavaToCocoaHandler.this.movie.setCurrentTime(new QTTime((long)(t.getSeconds() * (double)JavaToCocoaHandler.this.timeScale), JavaToCocoaHandler.this.timeScale));
            }
        });
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public float doPlayerSetRate(float rate) {
        return rate;
    }

    public boolean doPlayerStop() {
        logger.info("RococoaHandler.doPlayerStop");
        final QTMovie movieCopyOfReference = this.movie;
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                if (movieCopyOfReference != null) {
                    movieCopyOfReference.stop();
                }
            }
        });
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return true;
    }

    public boolean doPlayerSyncStart(Time t) {
        this.registerStopTriggerNotification();
        Future<?> future = executorService.submit(new Runnable(){

            public void run() {
                if (JavaToCocoaHandler.this.movie != null) {
                    JavaToCocoaHandler.this.movie.play();
                }
            }
        });
        try {
            future.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return true;
    }

    public Time getPlayerDuration() {
        if (this.getState() < 300) {
            return DURATION_UNKNOWN;
        }
        if (this.movie != null) {
            Future<Time> future = executorService.submit(new Callable<Time>(){

                @Override
                public Time call() {
                    QTTime duration = JavaToCocoaHandler.this.movie.duration();
                    double totalSeconds = (double)duration.timeValue / duration.timeScale.doubleValue();
                    return new Time(totalSeconds);
                }
            });
            try {
                return future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                ExceptionUtils.reportOrReturn(e);
                return DURATION_UNKNOWN;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "" + e, e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return DURATION_UNKNOWN;
            }
            catch (TimeoutException e) {
                return DURATION_UNKNOWN;
            }
        }
        return DURATION_UNKNOWN;
    }

    public synchronized void setMediaTime(QTTime qtTime) {
        this.readPositionInMedia = qtTime;
    }

    public synchronized Time getMediaTime() {
        if (this.getState() < 300) {
            return super.getMediaTime();
        }
        if (this.movie != null) {
            Future<?> future = executorService.submit(new Runnable(){

                public void run() {
                    if (JavaToCocoaHandler.this.movie != null) {
                        QTTime currentTime = JavaToCocoaHandler.this.movie.currentTime();
                        JavaToCocoaHandler.this.setMediaTime(currentTime);
                    }
                }
            });
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "" + e, e);
                ExceptionUtils.reportOrReturn(e);
                return DURATION_UNKNOWN;
            }
            catch (ExecutionException e) {
                logger.log(Level.WARNING, "" + e, e);
                ExceptionUtils.reportOrReturn(e.getCause());
                return DURATION_UNKNOWN;
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            if (this.readPositionInMedia != null) {
                double totalSeconds = (double)this.readPositionInMedia.timeValue / this.readPositionInMedia.timeScale.doubleValue();
                return new Time(totalSeconds);
            }
            return super.getMediaTime();
        }
        return super.getMediaTime();
    }

    public Time getPlayerStartLatency() {
        return new Time(0L);
    }

    public Component getVisualComponent() {
        assert (this.movieComponent != null);
        return this.movieComponent;
    }

    public Component getControlPanelComponent() {
        Component c = super.getControlPanelComponent();
        if (c == null) {
            c = ControlPanelFactorySingleton.getInstance().getControlPanelComponent(this);
            this.setControlPanelComponent(c);
        }
        return c;
    }

    static {
        try {
            QTKit instance = QTKit.instance;
            QTMovieView qTMovieView = QTMovieView.CLASS.create();
        }
        catch (UnsatisfiedLinkError error) {
            throw new ExceptionInInitializerError("librococoa.dylib could not be loaded!");
        }
    }
}

