/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.LibraryConverterHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.LibrarySettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.setting.AbstractSettingsGroup;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

class LibraryFileData
extends AbstractSettingsGroup {
    private static final Log LOG = LogFactory.getLog(LibraryFileData.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CategoryManager categoryManager;
    private static final String CURRENT_VERSION_KEY = "CURRENT_VERSION";
    private static final String SHARE_DATA_KEY = "SHARE_DATA";
    private static final String FILE_DATA_KEY = "FILE_DATA";
    private static final String COLLECTION_NAME_KEY = "COLLECTION_NAMES";
    private static final String COLLECTION_SHARE_DATA_KEY = "COLLECTION_SHARE_DATA";
    private static final String SAFE_URNS = "SAFE_URNS";
    static final Integer DEFAULT_SHARED_COLLECTION_ID = 0;
    private static final Integer MIN_COLLECTION_ID = 1;
    private final Version CURRENT_VERSION = Version.THREE;
    private final Map<String, List<Integer>> fileData = new HashMap<String, List<Integer>>();
    private final SortedMap<Integer, String> collectionNames = new TreeMap<Integer, String>();
    private final Map<Integer, List<String>> collectionShareData = new HashMap<Integer, List<String>>();
    private final Set<String> safeUrns = new HashSet<String>();
    private volatile boolean dirty = false;
    private final File saveFile = new File(CommonUtils.getUserSettingsDir(), "library5.dat");
    private final File backupFile = new File(CommonUtils.getUserSettingsDir(), "library5.bak");
    private volatile boolean loaded = false;

    LibraryFileData(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
        SettingsGroupManager.instance().addSettingsGroup(this);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void reload() {
        this.load();
    }

    @Override
    public boolean revertToDefault() {
        this.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.lock.writeLock().lock();
        try {
            this.dirty = true;
            this.fileData.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean save() {
        if (!this.loaded || !this.dirty) {
            return false;
        }
        HashMap<String, Object> save = new HashMap<String, Object>();
        this.lock.readLock().lock();
        try {
            save.put(CURRENT_VERSION_KEY, (Object)this.CURRENT_VERSION);
            save.put(FILE_DATA_KEY, this.fileData);
            save.put(COLLECTION_NAME_KEY, this.collectionNames);
            save.put(COLLECTION_SHARE_DATA_KEY, this.collectionShareData);
            save.put(SAFE_URNS, this.safeUrns);
            if (FileUtils.writeWithBackupFile(save, this.backupFile, this.saveFile, LOG)) {
                this.dirty = false;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return true;
    }

    void load() {
        boolean failed = false;
        if (!this.loadFromFile(this.saveFile)) {
            failed = !this.loadFromFile(this.backupFile);
        }
        this.dirty = failed;
        this.loaded = true;
    }

    private boolean loadFromFile(File file) {
        Map<String, Object> readMap = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object read = in.readObject();
            readMap = GenericsUtils.scanForMap(read, String.class, Object.class, GenericsUtils.ScanMode.REMOVE);
            if (readMap != null) {
                Object currentVersion = readMap.get(CURRENT_VERSION_KEY);
                if (currentVersion == null) {
                    currentVersion = Version.ONE;
                }
                if (!(currentVersion instanceof Version)) {
                    return false;
                }
                this.initializeFromVersion((Version)((Object)currentVersion), readMap);
                return true;
            }
        }
        catch (Throwable throwable) {
            LOG.error("Error loading library", throwable);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromVersion(Version version, Map<String, Object> readMap) {
        Set<String> safeUrns;
        Map<Integer, List<String>> collectionShareData;
        HashMap<Integer, String> collectionNames;
        HashMap<String, List<Integer>> fileData;
        switch (version) {
            case ONE: {
                Map<File, FileProperties> oldShareData = GenericsUtils.scanForMap(readMap.get(SHARE_DATA_KEY), File.class, FileProperties.class, GenericsUtils.ScanMode.REMOVE);
                fileData = new HashMap();
                collectionNames = new HashMap();
                collectionShareData = new HashMap<Integer, List<String>>();
                this.convertShareData(oldShareData, fileData, collectionNames, collectionShareData);
                final HashMap<String, List<Integer>> fileDataFinal = fileData;
                LibraryConverterHelper helper = new LibraryConverterHelper(new LibraryConverterHelper.FileAdder(){

                    @Override
                    public void addFile(File file) {
                        if (!fileDataFinal.containsKey(LibraryFileData.createKey(file))) {
                            fileDataFinal.put(LibraryFileData.createKey(file), Collections.emptyList());
                        }
                    }
                }, this.categoryManager);
                HashSet<File> convertedDirectories = new HashSet<File>();
                List<File> emptyList = Collections.emptyList();
                helper.convertSaveDirectories(emptyList, emptyList, convertedDirectories);
                safeUrns = new HashSet<String>();
                break;
            }
            case TWO: {
                fileData = new HashMap();
                Map<File, List<Integer>> oldFileData = GenericsUtils.scanForMapOfList(readMap.get(FILE_DATA_KEY), File.class, List.class, Integer.class, GenericsUtils.ScanMode.REMOVE);
                this.convertShareData(oldFileData, fileData);
                collectionNames = GenericsUtils.scanForMap(readMap.get(COLLECTION_NAME_KEY), Integer.class, String.class, GenericsUtils.ScanMode.REMOVE);
                collectionShareData = GenericsUtils.scanForMapOfList(readMap.get(COLLECTION_SHARE_DATA_KEY), Integer.class, List.class, String.class, GenericsUtils.ScanMode.REMOVE);
                safeUrns = GenericsUtils.scanForSet(readMap.get(SAFE_URNS), String.class, GenericsUtils.ScanMode.REMOVE);
                break;
            }
            case THREE: {
                fileData = GenericsUtils.scanForMapOfList(readMap.get(FILE_DATA_KEY), String.class, List.class, Integer.class, GenericsUtils.ScanMode.REMOVE);
                collectionNames = GenericsUtils.scanForMap(readMap.get(COLLECTION_NAME_KEY), Integer.class, String.class, GenericsUtils.ScanMode.REMOVE);
                collectionShareData = GenericsUtils.scanForMapOfList(readMap.get(COLLECTION_SHARE_DATA_KEY), Integer.class, List.class, String.class, GenericsUtils.ScanMode.REMOVE);
                safeUrns = GenericsUtils.scanForSet(readMap.get(SAFE_URNS), String.class, GenericsUtils.ScanMode.REMOVE);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid version: " + (Object)((Object)version));
            }
        }
        fileData = LibraryFileData.internKeys(fileData);
        safeUrns = LibraryFileData.internSafeUrns(safeUrns);
        this.validateCollectionData(fileData, collectionNames, collectionShareData);
        this.lock.writeLock().lock();
        try {
            this.clear();
            this.fileData.putAll(fileData);
            this.collectionNames.putAll(collectionNames);
            this.collectionShareData.putAll(collectionShareData);
            this.safeUrns.addAll(safeUrns);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static Map<String, List<Integer>> internKeys(Map<String, List<Integer>> oldFileData) {
        HashMap<String, List<Integer>> newFileData = new HashMap<String, List<Integer>>();
        for (Map.Entry<String, List<Integer>> entry : oldFileData.entrySet()) {
            newFileData.put(entry.getKey().intern(), entry.getValue());
        }
        return newFileData;
    }

    private static Set<String> internSafeUrns(Set<String> oldSafeUrns) {
        HashSet<String> newSafeUrns = new HashSet<String>();
        for (String entry : oldSafeUrns) {
            newSafeUrns.add(entry.intern());
        }
        return newSafeUrns;
    }

    private void validateCollectionData(Map<String, List<Integer>> fileData, Map<Integer, String> collectionNames, Map<Integer, List<String>> collectionShareData) {
    }

    private void convertShareData(Map<File, FileProperties> oldShareData, Map<String, List<Integer>> fileData, Map<Integer, String> collectionNames, Map<Integer, List<String>> collectionShareData) {
        int currentId = MIN_COLLECTION_ID;
        HashMap<String, Integer> friendToCollectionMap = new HashMap<String, Integer>();
        for (Map.Entry<File, FileProperties> data : oldShareData.entrySet()) {
            File file = data.getKey();
            FileProperties shareData = data.getValue();
            if (shareData == null || (shareData.friends == null || shareData.friends.isEmpty()) && !shareData.gnutella) {
                fileData.put(LibraryFileData.createKey(file), Collections.emptyList());
                continue;
            }
            if (shareData.friends != null) {
                for (String friend : shareData.friends) {
                    List<Integer> collections;
                    Integer collectionId = (Integer)friendToCollectionMap.get(friend);
                    if (collectionId == null) {
                        collectionId = currentId;
                        friendToCollectionMap.put(friend, collectionId);
                        collectionNames.put(collectionId, friend);
                        ArrayList<String> shareList = new ArrayList<String>(1);
                        shareList.add(friend);
                        collectionShareData.put(collectionId, shareList);
                        ++currentId;
                    }
                    if ((collections = fileData.get(LibraryFileData.createKey(file))) == null || collections == Collections.emptyList()) {
                        collections = new ArrayList<Integer>(1);
                        fileData.put(LibraryFileData.createKey(file), collections);
                    }
                    collections.add(collectionId);
                }
            }
            if (!shareData.gnutella) continue;
            List<Integer> collections = fileData.get(LibraryFileData.createKey(file));
            if (collections == null || collections == Collections.emptyList()) {
                collections = new ArrayList<Integer>(1);
                fileData.put(LibraryFileData.createKey(file), collections);
            }
            collections.add(DEFAULT_SHARED_COLLECTION_ID);
        }
    }

    private void convertShareData(Map<File, List<Integer>> oldFileData, Map<String, List<Integer>> fileData) {
        for (Map.Entry<File, List<Integer>> data : oldFileData.entrySet()) {
            fileData.put(LibraryFileData.createKey(data.getKey()), data.getValue());
        }
    }

    private static String createKey(File file) {
        return file.getPath().intern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileSafe(String urn) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.safeUrns.contains(urn);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileSafe(String urn, boolean safe) {
        this.lock.writeLock().lock();
        try {
            if (!safe) {
                if (this.safeUrns.remove(urn)) {
                    this.dirty = true;
                }
            } else if (this.safeUrns.add(urn)) {
                this.dirty = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFileData() {
        this.lock.writeLock().lock();
        try {
            if (!this.fileData.isEmpty()) {
                this.fileData.clear();
                this.dirty = true;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addManagedFile(File file) {
        this.lock.writeLock().lock();
        try {
            boolean changed = false;
            String key = LibraryFileData.createKey(file);
            if (!this.fileData.containsKey(key)) {
                this.fileData.put(key, Collections.emptyList());
                changed = true;
            }
            this.dirty |= changed;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOrRenameManagedFile(File file, File originalFile) {
        if (originalFile == null) {
            this.addManagedFile(file);
        } else {
            this.lock.writeLock().lock();
            try {
                boolean changed = false;
                String key = LibraryFileData.createKey(file);
                if (!this.fileData.containsKey(key)) {
                    String originalKey = LibraryFileData.createKey(originalFile);
                    if (this.fileData.containsKey(originalKey)) {
                        this.fileData.put(key, this.fileData.get(originalKey));
                        this.fileData.remove(originalKey);
                    } else {
                        this.fileData.put(key, Collections.emptyList());
                    }
                    changed = true;
                }
                this.dirty |= changed;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeManagedFile(File file) {
        this.lock.writeLock().lock();
        try {
            boolean changed = this.fileData.remove(LibraryFileData.createKey(file)) != null;
            this.dirty |= changed;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<File> getManagedFiles() {
        ArrayList<File> indivFiles = new ArrayList<File>();
        this.lock.readLock().lock();
        try {
            for (String key : this.fileData.keySet()) {
                indivFiles.add(new File(key));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return indivFiles;
    }

    boolean isIncompleteDirectory(File folder) {
        return FileUtils.canonicalize(SharingSettings.INCOMPLETE_DIRECTORY.get()).equals(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Integer> getStoredCollectionIds() {
        this.lock.readLock().lock();
        try {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.collectionNames.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileInCollection(File file, int collectionId, boolean contained) {
        this.lock.writeLock().lock();
        try {
            this.dirty = contained ? (this.dirty |= this.addFileToCollection(file, collectionId)) : (this.dirty |= this.removeFileFromCollection(file, collectionId));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFilesInCollection(Iterable<FileDesc> fileDescs, int collectionId, boolean contained) {
        this.lock.writeLock().lock();
        try {
            if (contained) {
                for (FileDesc fd : fileDescs) {
                    this.dirty |= this.addFileToCollection(fd.getFile(), collectionId);
                }
            } else {
                for (FileDesc fd : fileDescs) {
                    this.dirty |= this.removeFileFromCollection(fd.getFile(), collectionId);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean removeFileFromCollection(File file, int collectionId) {
        List<Integer> collections = this.fileData.get(LibraryFileData.createKey(file));
        if (collections == null || collections.isEmpty()) {
            return false;
        }
        return collections.remove((Object)collectionId);
    }

    private boolean addFileToCollection(File file, int collectionId) {
        boolean changed = false;
        List<Integer> collections = this.fileData.get(LibraryFileData.createKey(file));
        if (collections == null || collections == Collections.emptyList()) {
            collections = new ArrayList<Integer>(1);
            this.fileData.put(LibraryFileData.createKey(file), collections);
        }
        if (!collections.contains(collectionId)) {
            collections.add(collectionId);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileInCollection(File file, int collectionId) {
        this.lock.readLock().lock();
        try {
            List<Integer> collections = this.fileData.get(LibraryFileData.createKey(file));
            if (collections != null) {
                boolean bl = collections.contains(collectionId);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNameForCollection(int collectionId) {
        this.lock.readLock().lock();
        try {
            String string = (String)this.collectionNames.get(collectionId);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setNameForCollection(int collectionId, String name) {
        this.lock.writeLock().lock();
        try {
            String oldName = this.collectionNames.put(collectionId, name);
            boolean changed = oldName == null || !oldName.equals(name);
            this.dirty |= changed;
            boolean bl = changed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int createNewCollection(String name) {
        this.lock.writeLock().lock();
        try {
            int nextId = MIN_COLLECTION_ID;
            if (!this.collectionNames.isEmpty()) {
                nextId = this.collectionNames.lastKey() + 1;
            }
            this.collectionNames.put(nextId, name);
            this.dirty = true;
            int n = nextId;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCollection(int collectionId) {
        this.lock.writeLock().lock();
        try {
            this.dirty |= this.collectionNames.remove(collectionId) != null;
            this.dirty |= this.collectionShareData.remove(collectionId) != null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addFriendToCollection(int collectionId, String friendId) {
        this.lock.writeLock().lock();
        try {
            List<String> ids = this.collectionShareData.get(collectionId);
            if (ids == null) {
                ids = Collections.emptyList();
            }
            if (!ids.contains(friendId)) {
                ids = new ArrayList<String>(ids);
                ids.add(friendId);
                this.collectionShareData.put(collectionId, Collections.unmodifiableList(ids));
                this.dirty = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFriendFromCollection(int collectionId, String friendId) {
        this.lock.writeLock().lock();
        try {
            List<String> ids = this.collectionShareData.get(collectionId);
            if (ids != null && ids.contains(friendId)) {
                ids = new ArrayList<String>(ids);
                ids.remove(friendId);
                this.collectionShareData.put(collectionId, Collections.unmodifiableList(ids));
                this.dirty = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getFriendsForCollection(int collectionId) {
        this.lock.readLock().lock();
        try {
            List<String> ids = this.collectionShareData.get(collectionId);
            if (ids != null) {
                List<String> list = Collections.unmodifiableList(new ArrayList<String>(ids));
                return list;
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> setFriendsForCollection(int collectionId, List<String> newIds) {
        this.lock.writeLock().lock();
        try {
            List<String> oldIds = this.collectionShareData.get(collectionId);
            if (oldIds == null) {
                oldIds = Collections.emptyList();
            }
            if (new HashSet<String>(oldIds).equals(newIds)) {
                List<String> list = null;
                return list;
            }
            if (newIds.isEmpty()) {
                this.collectionShareData.remove(collectionId);
            } else {
                newIds = Collections.unmodifiableList(new ArrayList<String>(newIds));
                this.collectionShareData.put(collectionId, newIds);
            }
            this.dirty = true;
            List<String> list = oldIds;
            return list;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean isProgramManagingAllowed() {
        return LibrarySettings.ALLOW_PROGRAMS.getValue();
    }

    boolean isGnutellaDocumentSharingAllowed() {
        return LibrarySettings.ALLOW_DOCUMENT_GNUTELLA_SHARING.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peekPublicSharedListCount() {
        this.lock.readLock().lock();
        try {
            int count = 0;
            for (List<Integer> listForFile : this.fileData.values()) {
                if (!listForFile.contains(DEFAULT_SHARED_COLLECTION_ID)) continue;
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class FileProperties
    implements Serializable {
        private static final long serialVersionUID = 767248414812908206L;
        private boolean gnutella;
        private Set<String> friends;

        private FileProperties() {
        }

        public String toString() {
            return "FileProperties: gnutella: " + this.gnutella + ", friends: " + this.friends;
        }
    }

    private static enum Version {
        ONE,
        TWO,
        THREE;

    }
}

