/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters.response;

import com.google.common.collect.ImmutableMap;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.limewire.core.settings.FilterSettings;

public class XMLDocFilter
extends KeywordFilter {
    private final Map<String, String> disallowedFieldValues;
    private final Map<String, List<String>> disallowedExactFieldValues;

    XMLDocFilter() {
        this(FilterSettings.FILTER_ADULT.getValue(), true);
    }

    XMLDocFilter(boolean banAdult, boolean banPersonal) {
        super(banAdult, banPersonal);
        if (banAdult) {
            ImmutableMap.Builder<String, String> fields = new ImmutableMap.Builder<String, String>();
            fields.put("videos__video__type__", "adult");
            fields.put("videos__video__rating__", "adult");
            this.disallowedFieldValues = fields.build();
            ImmutableMap.Builder<String, List<String>> exactFields = new ImmutableMap.Builder<String, List<String>>();
            exactFields.put("videos__video__rating__", Arrays.asList("r", "nc-17"));
            this.disallowedExactFieldValues = exactFields.build();
        } else {
            this.disallowedFieldValues = Collections.emptyMap();
            this.disallowedExactFieldValues = Collections.emptyMap();
        }
    }

    @Override
    public boolean allow(QueryReply qr, Response response) {
        LimeXMLDocument doc = response.getDocument();
        return doc == null || this.allowDoc(doc);
    }

    private boolean allowDoc(LimeXMLDocument doc) {
        for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (this.matches(value)) {
                return false;
            }
            value = value.toLowerCase(Locale.US);
            String dis = this.disallowedFieldValues.get(key);
            if (dis != null && value.contains(dis)) {
                return false;
            }
            List<String> exact = this.disallowedExactFieldValues.get(key);
            if (exact == null) continue;
            for (String s : exact) {
                if (!s.equals(value)) continue;
                return false;
            }
        }
        return true;
    }
}

