/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.downloader.AbstractSourceRanker;
import com.limegroup.gnutella.downloader.LegacyRanker;
import com.limegroup.gnutella.downloader.MeshHandler;
import com.limegroup.gnutella.downloader.PingRanker;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import java.util.Collection;
import java.util.Collections;
import org.limewire.collection.MultiCollection;
import org.limewire.io.Address;
import org.limewire.io.Connectable;
import org.limewire.util.Visitor;

public class FriendsFirstSourceRanker
extends AbstractSourceRanker {
    private final LegacyRanker legacyRanker = new LegacyRanker();
    private final PingRanker pingRanker;

    public FriendsFirstSourceRanker(PingRanker pingRanker) {
        this.pingRanker = pingRanker;
    }

    @Override
    public void stop() {
        this.legacyRanker.stop();
        this.pingRanker.stop();
    }

    @Override
    protected void clearState() {
        this.legacyRanker.clearState();
        this.pingRanker.clearState();
    }

    @Override
    public void setMeshHandler(MeshHandler handler) {
        this.legacyRanker.setMeshHandler(handler);
        this.pingRanker.setMeshHandler(handler);
    }

    @Override
    public MeshHandler getMeshHandler() {
        return this.pingRanker.getMeshHandler();
    }

    @Override
    public boolean addToPool(Collection<? extends RemoteFileDescContext> hosts) {
        boolean added = false;
        for (RemoteFileDescContext remoteFileDescContext : hosts) {
            Address address = remoteFileDescContext.getAddress();
            if (address instanceof Connectable || address instanceof PushEndpoint) {
                added |= this.pingRanker.addToPool(remoteFileDescContext);
                continue;
            }
            added |= this.legacyRanker.addToPool(remoteFileDescContext);
        }
        return added;
    }

    @Override
    public boolean addToPool(RemoteFileDescContext host) {
        return this.addToPool(Collections.singleton(host));
    }

    @Override
    public RemoteFileDescContext getBest() {
        RemoteFileDescContext best = this.legacyRanker.getBest();
        return best != null ? best : this.pingRanker.getBest();
    }

    @Override
    protected boolean visitSources(Visitor<RemoteFileDescContext> contextVisitor) {
        if (this.pingRanker.visitSources(contextVisitor)) {
            return this.legacyRanker.visitSources(contextVisitor);
        }
        return false;
    }

    @Override
    public Collection<RemoteFileDescContext> getShareableHosts() {
        return new MultiCollection<RemoteFileDescContext>(this.pingRanker.getShareableHosts(), this.legacyRanker.getShareableHosts());
    }

    @Override
    public boolean hasMore() {
        return this.pingRanker.hasMore() || this.legacyRanker.hasMore();
    }
}

