/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.downloader.PushedSocketHandlerRegistry;
import com.limegroup.gnutella.messages.MessageFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.params.HttpParams;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.friend.api.FriendPresence;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.GUID;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.net.SocketsManager;
import org.limewire.service.ErrorService;

@EagerSingleton
class BrowseHostHandlerManagerImpl
implements BrowseHostHandlerManager,
Service {
    private static final Log LOG = LogFactory.getLog(BrowseHostHandlerManagerImpl.class);
    private final Map<GUID, BrowseHostHandler.PushRequestDetails> _pushedHosts = new HashMap<GUID, BrowseHostHandler.PushRequestDetails>();
    private final SocketsManager socketsManager;
    private final Provider<ForMeReplyHandler> forMeReplyHandler;
    private final ScheduledExecutorService backgroundExecutor;
    private final MessageFactory messageFactory;
    private final NetworkManager networkManager;
    private final PushEndpointFactory pushEndpointFactory;
    private final Provider<HttpParams> httpParams;

    @Inject
    public BrowseHostHandlerManagerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, SocketsManager socketsManager, Provider<ForMeReplyHandler> forMeReplyHandler, MessageFactory messageFactory, NetworkManager networkManager, PushEndpointFactory pushEndpointFactory, @Named(value="defaults") Provider<HttpParams> httpParams) {
        this.socketsManager = socketsManager;
        this.forMeReplyHandler = forMeReplyHandler;
        this.messageFactory = messageFactory;
        this.backgroundExecutor = backgroundExecutor;
        this.networkManager = networkManager;
        this.pushEndpointFactory = pushEndpointFactory;
        this.httpParams = httpParams;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Browse Host Handler");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
        this.backgroundExecutor.scheduleWithFixedDelay(new Expirer(), 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Inject
    public void register(PushedSocketHandlerRegistry registry) {
        registry.register(this);
    }

    @Override
    public BrowseHostHandler createBrowseHostHandler(GUID guid, GUID serventID) {
        return new BrowseHostHandler(guid, this.socketsManager, this.forMeReplyHandler, this.messageFactory, this.httpParams, this.networkManager, this.pushEndpointFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptPushedSocket(String file, int index, byte[] clientGUID, final Socket socket) {
        GUID serventID = new GUID(clientGUID);
        boolean retVal = false;
        LOG.trace("BHH.handlePush(): entered.");
        BrowseHostHandler.PushRequestDetails prd = null;
        Map<GUID, BrowseHostHandler.PushRequestDetails> map = this._pushedHosts;
        synchronized (map) {
            prd = this._pushedHosts.remove(serventID);
        }
        if (prd != null) {
            final BrowseHostHandler browseHostHandler = prd.getBrowseHostHandler();
            final FriendPresence friendPresence = prd.getFriendPresence();
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        browseHostHandler.browseHost(socket, friendPresence);
                    }
                    catch (IOException e) {
                        LOG.debug("error while push transfer", e);
                        browseHostHandler.failed();
                    }
                    catch (HttpException e) {
                        LOG.debug("error while push transfer", e);
                        browseHostHandler.failed();
                    }
                    catch (URISyntaxException e) {
                        LOG.debug("error while push transfer", e);
                        browseHostHandler.failed();
                    }
                    catch (InterruptedException e) {
                        LOG.debug("error while push transfer", e);
                        browseHostHandler.failed();
                    }
                }
            }, "BrowseHost");
            retVal = true;
        } else {
            LOG.debug("BHH.handlePush(): no matching BHH.");
        }
        LOG.trace("BHH.handlePush(): returning.");
        return retVal;
    }

    @Override
    public BrowseHostHandler createBrowseHostHandler(GUID browseGuid) {
        return new BrowseHostHandler(browseGuid, this.socketsManager, this.forMeReplyHandler, this.messageFactory, this.httpParams, this.networkManager, this.pushEndpointFactory);
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HashSet<GUID> toRemove = new HashSet<GUID>();
                Map map = BrowseHostHandlerManagerImpl.this._pushedHosts;
                synchronized (map) {
                    for (GUID key : BrowseHostHandlerManagerImpl.this._pushedHosts.keySet()) {
                        BrowseHostHandler.PushRequestDetails currPRD = (BrowseHostHandler.PushRequestDetails)BrowseHostHandlerManagerImpl.this._pushedHosts.get(key);
                        if (currPRD == null || !currPRD.isExpired()) continue;
                        LOG.debug("Expirer.run(): expiring a badboy.");
                        toRemove.add(key);
                        currPRD.getBrowseHostHandler().failed();
                    }
                    for (GUID key : toRemove) {
                        BrowseHostHandlerManagerImpl.this._pushedHosts.remove(key);
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

