/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel0
extends BasicWizardIterator.Panel {
    private NewOptionsIterator.DataModel data;
    private DocumentListener fieldsDL;
    private JRadioButton advancedButton;
    private JCheckBox allowSecondaryPanelsCheckBox;
    private ButtonGroup buttonGroup1;
    private JTextField categoryNameField;
    private JLabel categoryNameLbl;
    private JLabel displayNameLbl1;
    private JPanel dummyPanel;
    private JButton iconButton;
    private JTextField iconField;
    private JLabel iconLbl;
    private JLabel keywordsLabel;
    private JRadioButton optionsCategoryButton;
    private JLabel primKeywordsLabel;
    private JTextField primaryKwField;
    private JComboBox primaryPanelCombo;
    private JLabel primaryPanelComboLbl;
    private JTextField secondaryKwField;
    private JTextField secondaryPanelTitle;

    public OptionsPanel0(WizardDescriptor wizardDescriptor, NewOptionsIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsWizardTitle"));
    }

    private String[] getPrimaryIdsFromLayer() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            FileSystem fileSystem = LayerUtils.getEffectiveSystemFilesystem(this.data.getProject());
            FileObject fileObject = fileSystem.findResource("OptionsDialog");
            if (fileObject != null) {
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject2 = fileObjectArray[i];
                    if (fileObject2.isFolder()) continue;
                    arrayList.add(fileObject2.getName());
                }
                Collections.sort(arrayList);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(OptionsPanel0.class.getName()).log(Level.INFO, null, iOException);
        }
        arrayList.remove("Advanced");
        arrayList.add(0, "Advanced");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addListeners() {
        if (this.fieldsDL == null) {
            this.fieldsDL = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    OptionsPanel0.this.updateData();
                }
            };
            this.categoryNameField.getDocument().addDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().addDocumentListener(this.fieldsDL);
            this.iconField.getDocument().addDocumentListener(this.fieldsDL);
            this.primaryKwField.getDocument().addDocumentListener(this.fieldsDL);
            this.secondaryKwField.getDocument().addDocumentListener(this.fieldsDL);
            if (this.primaryPanelCombo.getEditor().getEditorComponent() instanceof JTextField) {
                ((JTextField)this.primaryPanelCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.fieldsDL);
            }
        }
    }

    private void removeListeners() {
        if (this.fieldsDL != null) {
            this.categoryNameField.getDocument().removeDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().removeDocumentListener(this.fieldsDL);
            this.iconField.getDocument().removeDocumentListener(this.fieldsDL);
            this.fieldsDL = null;
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
    }

    private boolean smallerThan110(String string) {
        String[] stringArray = string.split("\\.");
        return Integer.parseInt(stringArray[0]) <= 1 && Integer.parseInt(stringArray[1]) < 10;
    }

    private void updateData() {
        NbPlatform nbPlatform = LayerUtils.getPlatformForProject(this.data.getProject());
        if (this.smallerThan110(nbPlatform.getModule("org.netbeans.modules.options.api").getSpecificationVersion())) {
            this.setError(NbBundle.getMessage(OptionsPanel0.class, (String)"MSG_INVALID_PLATFORM"));
            return;
        }
        int n = 0;
        if (this.advancedButton.isSelected()) {
            assert (!this.optionsCategoryButton.isSelected());
            n = this.data.setDataForSecondaryPanel(this.primaryPanelCombo.getEditor().getItem().toString(), this.secondaryPanelTitle.getText(), this.secondaryKwField.getText());
        } else {
            assert (this.optionsCategoryButton.isSelected());
            n = this.data.setDataForPrimaryPanel(this.categoryNameField.getText(), this.iconField.getText(), this.allowSecondaryPanelsCheckBox.isSelected(), this.primaryKwField.getText());
        }
        String string = this.data.getMessage(n);
        if (NewOptionsIterator.DataModel.isSuccessCode(n)) {
            this.markValid();
        } else if (NewOptionsIterator.DataModel.isErrorCode(n)) {
            this.setError(string);
        } else if (NewOptionsIterator.DataModel.isWarningCode(n)) {
            this.setWarning(string);
        } else if (NewOptionsIterator.DataModel.isInfoCode(n)) {
            this.setInfo(string, false);
        } else assert (false) : n;
    }

    protected String getPanelName() {
        return NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsPanel0_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel0.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(OptionsPanel0.class, (String)string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_OptionsPanel0"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_Advanced"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_OptionsCategory"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_DisplayName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_CategoryName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconPath"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconButton"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_AllowSecondaryPanels"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_PrimaryPanelCombo"));
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void enableDisable() {
        boolean bl = this.advancedButton.isSelected();
        assert (bl != this.optionsCategoryButton.isSelected());
        this.categoryNameField.setEnabled(!bl);
        this.categoryNameLbl.setEnabled(!bl);
        this.iconButton.setEnabled(!bl);
        this.iconField.setEnabled(!bl);
        this.iconLbl.setEnabled(!bl);
        this.primaryKwField.setEnabled(!bl);
        this.primKeywordsLabel.setEnabled(!bl);
        this.allowSecondaryPanelsCheckBox.setEnabled(!bl);
        this.primaryPanelComboLbl.setEnabled(bl);
        this.primaryPanelCombo.setEnabled(bl);
        this.secondaryPanelTitle.setEnabled(bl);
        this.secondaryKwField.setEditable(bl);
        this.keywordsLabel.setEnabled(bl);
        this.displayNameLbl1.setEnabled(bl);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.advancedButton = new JRadioButton();
        this.optionsCategoryButton = new JRadioButton();
        this.dummyPanel = new JPanel();
        this.categoryNameLbl = new JLabel();
        this.categoryNameField = new JTextField();
        this.displayNameLbl1 = new JLabel();
        this.secondaryPanelTitle = new JTextField();
        this.iconLbl = new JLabel();
        this.iconField = new JTextField();
        this.iconButton = new JButton();
        this.allowSecondaryPanelsCheckBox = new JCheckBox();
        this.primaryPanelComboLbl = new JLabel();
        this.primaryPanelCombo = new JComboBox();
        this.keywordsLabel = new JLabel();
        this.primKeywordsLabel = new JLabel();
        this.secondaryKwField = new JTextField();
        this.primaryKwField = new JTextField();
        this.buttonGroup1.add(this.advancedButton);
        this.advancedButton.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)resourceBundle.getString("LBL_Advanced"));
        this.advancedButton.setMargin(new Insets(0, 0, 0, 0));
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.advancedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.optionsCategoryButton);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsCategoryButton, (String)resourceBundle.getString("LBL_OptionsCategory"));
        this.optionsCategoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.optionsCategoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.optionsCategoryButtonActionPerformed(actionEvent);
            }
        });
        this.categoryNameLbl.setLabelFor(this.categoryNameField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLbl, (String)resourceBundle.getString("LBL_CategoryName"));
        this.categoryNameLbl.setEnabled(false);
        this.categoryNameField.setEnabled(false);
        this.displayNameLbl1.setLabelFor(this.secondaryPanelTitle);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLbl1, (String)resourceBundle.getString("LBL_DisplaName"));
        this.iconLbl.setLabelFor(this.iconField);
        Mnemonics.setLocalizedText((JLabel)this.iconLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon"));
        this.iconLbl.setEnabled(false);
        this.iconField.setEditable(false);
        this.iconField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"CTL_None"));
        this.iconField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon_Browse"));
        this.iconButton.setEnabled(false);
        this.iconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.iconButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.allowSecondaryPanelsCheckBox, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_AllowSecondaryPanels"));
        this.allowSecondaryPanelsCheckBox.setEnabled(false);
        this.allowSecondaryPanelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.allowSecondaryPanelsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.primaryPanelComboLbl.setLabelFor(this.primaryPanelCombo);
        Mnemonics.setLocalizedText((JLabel)this.primaryPanelComboLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_PrimaryPanelCombo"));
        this.primaryPanelCombo.setEditable(true);
        this.primaryPanelCombo.setModel(new DefaultComboBoxModel<String>(this.getPrimaryIdsFromLayer()));
        this.primaryPanelCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.primaryPanelComboActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keywordsLabel, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Keywords"));
        Mnemonics.setLocalizedText((JLabel)this.primKeywordsLabel, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Keywords"));
        this.primKeywordsLabel.setEnabled(false);
        this.secondaryKwField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"OptionsPanel0.secondaryKwField.text"));
        this.primaryKwField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"OptionsPanel0.primaryKwField.text"));
        this.primaryKwField.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.advancedButton, -2, 400, -2).add(98, 98, 98)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.displayNameLbl1).add((Component)this.primaryPanelComboLbl).add((Component)this.keywordsLabel)).add(22, 22, 22).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.secondaryKwField, -1, 406, Short.MAX_VALUE).add((Component)this.primaryPanelCombo, 0, 406, Short.MAX_VALUE).add((Component)this.secondaryPanelTitle, -1, 406, Short.MAX_VALUE)).add(10, 10, 10)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(235, 235, 235).add((Component)this.dummyPanel, -2, -1, -2))).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.optionsCategoryButton, -2, 400, -2).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.categoryNameLbl).add((Component)this.iconLbl)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.iconField, -1, 304, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.iconButton).add(18, 18, 18)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.categoryNameField, -1, 405, Short.MAX_VALUE).addContainerGap()))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.primKeywordsLabel).add(49, 49, 49).add((Component)this.primaryKwField, -1, 405, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.allowSecondaryPanelsCheckBox, -2, 215, -2).addContainerGap(320, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.advancedButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.primaryPanelComboLbl).add((Component)this.primaryPanelCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.displayNameLbl1).add((Component)this.secondaryPanelTitle, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.keywordsLabel).add((Component)this.secondaryKwField, -2, -1, -2)).add(18, 18, 18).add((Component)this.optionsCategoryButton).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.categoryNameLbl).add((Component)this.categoryNameField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.iconLbl).add((Component)this.iconField, -2, -1, -2).add((Component)this.iconButton)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.primKeywordsLabel).add((Component)this.primaryKwField, -2, -1, -2)).addPreferredGap(1).add((Component)this.allowSecondaryPanelsCheckBox).add(68, 68, 68).add((Component)this.dummyPanel, -2, -1, -2)));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.advancedButton.AccessibleContext.accessibleDescription"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.optionsCategoryButton.AccessibleContext.accessibleDescription"));
        this.dummyPanel.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleName"));
        this.dummyPanel.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleDescription"));
        this.categoryNameLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameLbl.AccessibleContext.accessibleDescription"));
        this.categoryNameField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleDescription"));
        this.displayNameLbl1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameLbl1.AccessibleContext.accessibleDescription"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleName"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleDescription"));
        this.iconLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconLbl.AccessibleContext.accessibleDescription"));
        this.iconField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleDescription"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconButton.AccessibleContext.accessibleDescription"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.allowSecondaryPanelsCheckBox.AccessibleContext.accessibleDescription"));
        this.primaryPanelComboLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelComboLbl.AccessibleContext.accessibleDescription"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleName"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleDescription"));
    }

    private void optionsCategoryButtonActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
        this.updateData();
    }

    private void advancedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
        this.updateData();
    }

    private void iconButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = UIUtil.getIconFileChooser(this.iconField.getText());
        int n = jFileChooser.showDialog(this, OptionsPanel0.getMessage("LBL_Select"));
        if (n == 0) {
            String string;
            File file = jFileChooser.getSelectedFile();
            String string2 = file.getAbsolutePath();
            if (!string2.contains(string = this.data.getProject().getProjectDirectory() + "/src")) {
                String string3 = file.getName();
                String string4 = this.data.getPackageName().replace('.', '/');
                File file2 = new File(string + "/" + string4, string3);
                try {
                    this.copyFile(file, file2);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                this.iconField.setText(string4 + "/" + string3);
            } else {
                this.iconField.setText(string2.substring(string.length() + 1));
            }
        }
    }

    private void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        fileChannel.close();
        fileChannel2.close();
    }

    private void allowSecondaryPanelsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    private void primaryPanelComboActionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }
}

