/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.ClusterInfo;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteProperties
extends ModuleProperties {
    public static final String DISABLED_MODULES_PROPERTY = "disabled.modules";
    public static final String ENABLED_CLUSTERS_PROPERTY = "enabled.clusters";
    public static final String DISABLED_CLUSTERS_PROPERTY = "disabled.clusters";
    public static final String NB_PLATFORM_PROPERTY = "nbPlatform";
    public static final String JAVA_PLATFORM_PROPERTY = "nbjdk.active";
    public static final String CLUSTER_DIR = "build/cluster";
    public static final String ACTIVE_NB_PLATFORM_PROPERTY = "nbplatform.active";
    public static final String ACTIVE_NB_PLATFORM_DIR_PROPERTY = "nbplatform.active.dir";
    public static final String CLUSTER_PATH_PROPERTY = "cluster.path";
    public static final String CLUSTER_PATH_WDC_PROPERTY = "cluster.path.with.disabled.clusters";
    public static final String CLUSTER_SRC_PREFIX = "extcluster.";
    private NbPlatform activePlatform;
    private JavaPlatform activeJavaPlatform;
    private SuiteProject project;
    private Set<NbModuleProject> origSubModules;
    private Set<NbModuleProject> subModules;
    private CustomizerComponentFactory.SuiteSubModulesListModel moduleListModel;
    private String[] disabledModules;
    private String[] enabledClusters;
    private boolean changedDisabledModules;
    private boolean changedEnabledClusters;
    private boolean clusterPathChanged;
    private final BasicBrandingModel brandingModel;
    private Set<ClusterInfo> clusterPath;
    private boolean refreshBuildScripts;

    public SuiteProperties(SuiteProject suiteProject, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, Set<NbModuleProject> set) {
        super(antProjectHelper, propertyEvaluator);
        this.project = suiteProject;
        this.refresh(set);
        this.disabledModules = SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_MODULES_PROPERTY);
        this.enabledClusters = SuiteProperties.getArrayProperty(propertyEvaluator, ENABLED_CLUSTERS_PROPERTY);
        if (this.enabledClusters.length == 0) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (ModuleEntry object : this.activePlatform.getModules()) {
                treeSet.add(object.getClusterDirectory().getName());
            }
            treeSet.removeAll(Arrays.asList(SuiteProperties.getArrayProperty(propertyEvaluator, DISABLED_CLUSTERS_PROPERTY)));
            this.enabledClusters = new String[treeSet.size()];
            int n = 0;
            for (String string : treeSet) {
                this.enabledClusters[n++] = SingleModuleProperties.clusterBaseName(string);
            }
        }
        this.brandingModel = new BasicBrandingModel(this);
    }

    void refresh(Set<NbModuleProject> set) {
        this.reloadProperties();
        this.origSubModules = Collections.unmodifiableSet(set);
        this.subModules = set;
        this.moduleListModel = null;
        this.activePlatform = this.project.getPlatform(true);
        this.activeJavaPlatform = ModuleProperties.findJavaPlatformByID(this.getEvaluator().getProperty(JAVA_PLATFORM_PROPERTY));
        this.firePropertiesRefreshed();
    }

    public SuiteProject getProject() {
        return this.project;
    }

    @Override
    Map<String, String> getDefaultValues() {
        return Collections.emptyMap();
    }

    public NbPlatform getActivePlatform() {
        return this.activePlatform;
    }

    void setActivePlatform(NbPlatform nbPlatform) {
        NbPlatform nbPlatform2 = this.activePlatform;
        this.activePlatform = nbPlatform;
        if (this.clusterPath != null) {
            EditableProperties editableProperties = new EditableProperties(false);
            this.storeClusterPath(editableProperties);
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.fixedPropertyProvider((Map)editableProperties), new PropertyProvider(){

                public Map<String, String> getProperties() {
                    return SuiteProperties.this.getEvaluator().getProperties();
                }

                public void addChangeListener(ChangeListener changeListener) {
                }

                public void removeChangeListener(ChangeListener changeListener) {
                }
            }});
            this.clusterPath = ClusterUtils.evaluateClusterPath(this.getProjectDirectoryFile(), propertyEvaluator, this.getActivePlatform().getDestDir());
        }
        this.firePropertyChange(NB_PLATFORM_PROPERTY, nbPlatform2, nbPlatform);
    }

    JavaPlatform getActiveJavaPlatform() {
        return this.activeJavaPlatform;
    }

    void setActiveJavaPlatform(JavaPlatform javaPlatform) {
        JavaPlatform javaPlatform2 = this.activeJavaPlatform;
        if (javaPlatform != javaPlatform2) {
            this.activeJavaPlatform = javaPlatform;
            this.firePropertyChange(JAVA_PLATFORM_PROPERTY, javaPlatform2, javaPlatform);
        }
    }

    String[] getEnabledClusters() {
        return this.enabledClusters;
    }

    String[] getDisabledModules() {
        return this.disabledModules;
    }

    public void setEnabledClusters(String[] stringArray) {
        if (((Object)Arrays.asList(this.enabledClusters)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.enabledClusters = stringArray;
        this.changedEnabledClusters = true;
    }

    public void setDisabledModules(String[] stringArray) {
        if (((Object)Arrays.asList(this.disabledModules)).equals(Arrays.asList(stringArray))) {
            return;
        }
        this.disabledModules = stringArray;
        this.changedDisabledModules = true;
    }

    public static String[] getArrayProperty(PropertyEvaluator propertyEvaluator, String string) {
        String string2 = propertyEvaluator.getProperty(string);
        String[] stringArray = null;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            stringArray = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringTokenizer.nextToken().trim();
            }
        }
        return stringArray == null ? new String[]{} : stringArray;
    }

    @Override
    public void storeProperties() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        NbPlatform nbPlatform = this.getActivePlatform();
        ModuleProperties.storePlatform(this.getHelper(), nbPlatform);
        ModuleProperties.storeJavaPlatform(this.getHelper(), this.getEvaluator(), this.getActiveJavaPlatform(), false);
        this.getBrandingModel().store();
        CustomizerComponentFactory.SuiteSubModulesListModel suiteSubModulesListModel = this.getModulesListModel();
        if (suiteSubModulesListModel.isChanged()) {
            SuiteUtils.replaceSubModules(this);
        }
        if (this.changedDisabledModules || this.changedEnabledClusters || this.clusterPathChanged) {
            Object object;
            int n;
            Object object2;
            EditableProperties editableProperties = this.getHelper().getProperties("nbproject/platform.properties");
            if (this.changedDisabledModules) {
                object2 = (String[])this.disabledModules.clone();
                for (n = 0; n < this.disabledModules.length - 1; ++n) {
                    object2[n] = this.disabledModules[n] + ',';
                }
                editableProperties.setProperty(DISABLED_MODULES_PROPERTY, (String[])object2);
                this.setProperty(DISABLED_MODULES_PROPERTY, (String)null);
            }
            if (this.changedEnabledClusters) {
                object2 = new String[this.enabledClusters.length];
                for (n = 0; n < this.enabledClusters.length; ++n) {
                    object2[n] = SuiteProperties.representationOfCluster(this.enabledClusters[n], nbPlatform);
                    if (n >= this.enabledClusters.length - 1) continue;
                    object2[n] = (String)object2[n] + ',';
                }
                editableProperties.setProperty(ENABLED_CLUSTERS_PROPERTY, (String[])object2);
                this.setProperty(ENABLED_CLUSTERS_PROPERTY, (String)null);
                if (nbPlatform == null || nbPlatform.getHarnessVersion() < 2) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    object = this.activePlatform.getModules();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        ModuleEntry moduleEntry = (ModuleEntry)iterator.next();
                        treeSet.add(moduleEntry.getClusterDirectory().getName());
                    }
                    treeSet.removeAll(Arrays.asList(this.enabledClusters));
                    object2 = treeSet.toArray(new String[treeSet.size()]);
                    for (int i = 0; i < ((Object)object2).length - 1; ++i) {
                        object2[i] = (String)object2[i] + ',';
                    }
                    editableProperties.setProperty(DISABLED_CLUSTERS_PROPERTY, (String[])object2);
                    editableProperties.setComment(DISABLED_CLUSTERS_PROPERTY, new String[]{"# Deprecated since 5.0u1; for compatibility with 5.0:"}, false);
                }
            }
            if (this.clusterPathChanged) {
                this.storeClusterPath(editableProperties);
            }
            this.getHelper().putProperties("nbproject/platform.properties", editableProperties);
            if (this.refreshBuildScripts) {
                try {
                    object2 = SuiteUtils.getSubProjects(this.getProject());
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = (NbModuleProject)iterator.next();
                        ((NbModuleProject)object).refreshBuildScripts(false, nbPlatform);
                    }
                    this.getProject().refreshBuildScripts(false);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
            this.changedDisabledModules = false;
            this.changedEnabledClusters = false;
            this.clusterPathChanged = false;
            this.refreshBuildScripts = false;
        }
        super.storeProperties();
    }

    private static String representationOfCluster(String string, NbPlatform nbPlatform) {
        if (nbPlatform != null && nbPlatform.getHarnessVersion() >= 6) {
            return SingleModuleProperties.clusterBaseName(string);
        }
        return string;
    }

    public Set<ClusterInfo> getClusterPath() {
        if (this.clusterPath == null) {
            this.clusterPath = ClusterUtils.evaluateClusterPath(this.getProjectDirectoryFile(), this.getEvaluator(), this.getActivePlatform().getDestDir());
        }
        return this.clusterPath;
    }

    public void setClusterPath(List<ClusterInfo> list) {
        LinkedHashSet<ClusterInfo> linkedHashSet = new LinkedHashSet<ClusterInfo>(list);
        if (((Object)linkedHashSet).equals(this.getClusterPath())) {
            return;
        }
        if (this.clusterPath.isEmpty()) {
            this.refreshBuildScripts = true;
        }
        this.clusterPath = linkedHashSet;
        this.clusterPathChanged = true;
    }

    public static String toPlatformClusterEntry(String string) {
        return "${nbplatform.active.dir}/" + SingleModuleProperties.clusterBaseName(string);
    }

    File evaluateClusterPathEntry(String string) {
        return ClusterUtils.evaluateClusterPathEntry(string, this.getProjectDirectoryFile(), this.getEvaluator(), this.getActivePlatform().getDestDir());
    }

    Set<NbModuleProject> getSubModules() {
        return this.getModulesListModel().getSubModules();
    }

    Set<NbModuleProject> getOrigSubModules() {
        return this.origSubModules;
    }

    CustomizerComponentFactory.SuiteSubModulesListModel getModulesListModel() {
        if (this.moduleListModel == null) {
            this.moduleListModel = new CustomizerComponentFactory.SuiteSubModulesListModel(this.subModules);
        }
        return this.moduleListModel;
    }

    public BasicBrandingModel getBrandingModel() {
        return this.brandingModel;
    }

    private void storeClusterPath(EditableProperties editableProperties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        for (ClusterInfo clusterInfo : this.clusterPath) {
            String string;
            String string2;
            if (clusterInfo.isPlatformCluster()) {
                string2 = clusterInfo.getClusterDir().getName();
                string = SuiteProperties.toPlatformClusterEntry(string2);
                arrayList.add(string);
                arrayList2.add(string);
                continue;
            }
            string2 = PropertyUtils.relativizeFile((File)this.getProjectDirectoryFile(), (File)clusterInfo.getClusterDir());
            if (clusterInfo.isEnabled()) {
                arrayList.add(string2);
            } else {
                bl = true;
            }
            arrayList2.add(string2);
            if (!clusterInfo.isExternalCluster()) continue;
            if (clusterInfo.getSourceRoots() != null) {
                string = CLUSTER_SRC_PREFIX + string2 + ".sources";
                editableProperties.setProperty(string, Util.urlsToAntPath(clusterInfo.getSourceRoots()));
            }
            if (clusterInfo.getJavadocRoots() != null) {
                string = CLUSTER_SRC_PREFIX + string2 + ".javadoc";
                editableProperties.setProperty(string, Util.urlsToAntPath(clusterInfo.getJavadocRoots()));
            }
            ModuleList.refreshClusterModuleList(clusterInfo.getClusterDir());
        }
        if (bl) {
            editableProperties.setProperty(CLUSTER_PATH_WDC_PROPERTY, SuiteUtils.getAntProperty(arrayList2));
        } else {
            editableProperties.remove((Object)CLUSTER_PATH_WDC_PROPERTY);
        }
        editableProperties.setProperty(CLUSTER_PATH_PROPERTY, SuiteUtils.getAntProperty(arrayList));
        editableProperties.remove((Object)ENABLED_CLUSTERS_PROPERTY);
    }
}

