/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileObjectCrawler
extends Crawler {
    private static final Logger LOG = Logger.getLogger(FileObjectCrawler.class.getName());
    private final FileObject root;
    private final ClassPath.Entry entry;
    private final FileObject[] files;

    public FileObjectCrawler(FileObject fileObject, boolean bl, ClassPath.Entry entry, CancelRequest cancelRequest) throws IOException {
        super(fileObject.getURL(), bl, true, cancelRequest);
        this.root = fileObject;
        this.entry = entry;
        this.files = null;
    }

    public FileObjectCrawler(FileObject fileObject, FileObject[] fileObjectArray, boolean bl, ClassPath.Entry entry, CancelRequest cancelRequest) throws IOException {
        super(fileObject.getURL(), bl, false, cancelRequest);
        this.root = fileObject;
        this.entry = entry;
        this.files = fileObjectArray;
    }

    @Override
    protected boolean collectResources(Collection<IndexableImpl> collection, Collection<IndexableImpl> collection2) {
        Stats stats;
        boolean bl = true;
        long l = System.currentTimeMillis();
        Stats stats2 = stats = LOG.isLoggable(Level.FINE) ? new Stats() : null;
        if (this.files != null) {
            Serializable serializable;
            if (this.files.length > 1) {
                serializable = new HashMap();
                for (Object object : this.files) {
                    FileObject fileObject = object.getParent();
                    HashSet<FileObject> hashSet = (HashSet<FileObject>)serializable.get(fileObject);
                    if (hashSet == null) {
                        hashSet = new HashSet<FileObject>();
                        serializable.put(fileObject, hashSet);
                    }
                    hashSet.add((FileObject)object);
                }
                for (FileObject fileObject : serializable.keySet()) {
                    Object object;
                    Set set = (Set)serializable.get(fileObject);
                    object = this.getRelativePath(this.root, fileObject);
                    if (object == null || (bl = this.collect(set.toArray(new FileObject[set.size()]), this.root, collection, collection2, stats, this.entry, (StringBuilder)object))) continue;
                    break;
                }
            } else if (this.files.length == 1 && (serializable = this.getRelativePath(this.root, this.files[0].getParent())) != null) {
                bl = this.collect(this.files, this.root, collection, collection2, stats, this.entry, (StringBuilder)serializable);
            }
        } else {
            bl = this.collect(this.root.getChildren(), this.root, collection, collection2, stats, this.entry, new StringBuilder());
        }
        long l2 = System.currentTimeMillis();
        if (LOG.isLoggable(Level.FINE)) {
            String string;
            try {
                string = this.root.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                string = this.root.toString();
            }
            LOG.log(Level.FINE, String.format("Up-to-date check of %d files under %s took %d ms", stats.filesCount, string, l2 - l));
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "File extensions histogram for {0}:", string);
                Stats.logHistogram(Level.FINER, stats.extensions);
                LOG.finer("----");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collect(FileObject[] fileObjectArray, FileObject fileObject, Collection<IndexableImpl> collection, Collection<IndexableImpl> collection2, Stats stats, ClassPath.Entry entry, StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        for (FileObject fileObject2 : fileObjectArray) {
            if (this.isCancelled()) {
                return false;
            }
            if (!fileObject2.isValid() || !VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            stringBuilder.append(fileObject2.getNameExt());
            boolean bl = fileObject2.isFolder();
            if (bl) {
                stringBuilder.append('/');
            }
            String string = stringBuilder.toString();
            try {
                if (entry != null && !entry.includes(string)) continue;
                if (bl) {
                    if (this.collect(fileObject2.getChildren(), fileObject, collection, collection2, stats, entry, stringBuilder)) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                if (stats != null) {
                    ++stats.filesCount;
                    Stats.inc(stats.extensions, fileObject2.getExt());
                }
                FileObjectIndexable fileObjectIndexable = new FileObjectIndexable(fileObject, string);
                collection2.add(fileObjectIndexable);
                if (this.isUpToDate(fileObject2, string) || collection == null) continue;
                collection.add(fileObjectIndexable);
            }
            finally {
                stringBuilder.delete(n, stringBuilder.length());
            }
        }
        return true;
    }

    private StringBuilder getRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        if (string != null) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (stringBuilder.length() > 0) {
                stringBuilder.append('/');
            }
            return stringBuilder;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stats {
        public int filesCount;
        public Map<String, Integer> extensions = new HashMap<String, Integer>();
        public Map<String, Integer> mimeTypes = new HashMap<String, Integer>();
        private static final Comparator<Integer> REVERSE = new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return -1 * n.compareTo(n2);
            }
        };

        private Stats() {
        }

        public static void inc(Map<String, Integer> map, String string) {
            Integer n = map.get(string);
            if (n == null) {
                map.put(string, 1);
            } else {
                map.put(string, n + 1);
            }
        }

        public static void logHistogram(Level level, Map<String, Integer> map) {
            TreeMap<Integer, TreeSet<String>> treeMap = new TreeMap<Integer, TreeSet<String>>(REVERSE);
            for (String object : map.keySet()) {
                Integer n = map.get(object);
                TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(n);
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    treeMap.put(n, treeSet);
                }
                treeSet.add(object);
            }
            for (Integer n : treeMap.keySet()) {
                for (TreeSet<String> treeSet : (Set)treeMap.get(n)) {
                    LOG.log(level, "{0}: {1}", new Object[]{treeSet, n});
                }
            }
        }
    }
}

