/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class CacheFolder {
    private static final Logger LOG = Logger.getLogger(CacheFolder.class.getName());
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "index";
    private static final String SEGMENTS_FILE = "segments";
    private static final String SLICE_PREFIX = "s";
    private static FileObject cacheFolder;
    private static Properties segments;
    private static Map<String, String> invertedSegments;
    private static int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSegments(FileObject fileObject) throws IOException {
        if (segments == null) {
            assert (fileObject != null);
            segments = new Properties();
            invertedSegments = new HashMap<String, String>();
            FileObject fileObject2 = fileObject.getFileObject(SEGMENTS_FILE);
            if (fileObject2 != null) {
                InputStream inputStream = fileObject2.getInputStream();
                try {
                    segments.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            for (Map.Entry entry : segments.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                invertedSegments.put(string2, string);
                try {
                    index = Math.max(index, Integer.parseInt(string.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.log(Level.FINE, null, numberFormatException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSegments(FileObject fileObject) throws IOException {
        assert (fileObject != null);
        File file = FileUtil.toFile((FileObject)fileObject);
        assert (file != null);
        FileObject fileObject2 = FileUtil.createData((File)new File(file, SEGMENTS_FILE));
        OutputStream outputStream = fileObject2.getOutputStream();
        try {
            segments.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    public static synchronized URL getSourceRootForDataFolder(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null || !fileObject2.equals(cacheFolder)) {
            return null;
        }
        String string = segments.getProperty(fileObject.getName());
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, null, iOException);
            }
        }
        return null;
    }

    public static FileObject getDataFolder(URL uRL) throws IOException {
        return CacheFolder.getDataFolder(uRL, false);
    }

    public static FileObject getDataFolder(final URL uRL, final boolean bl) throws IOException {
        final FileObject fileObject = CacheFolder.getCacheFolder();
        final FileObject[] fileObjectArray = new FileObject[]{null};
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Class<CacheFolder> clazz = CacheFolder.class;
                synchronized (CacheFolder.class) {
                    CacheFolder.loadSegments(fileObject);
                    String string = uRL.toExternalForm();
                    String string2 = (String)invertedSegments.get(string);
                    if (string2 == null) {
                        if (bl) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        string2 = CacheFolder.SLICE_PREFIX + ++index;
                        while (segments.getProperty(string2) != null) {
                            string2 = CacheFolder.SLICE_PREFIX + ++index;
                        }
                        segments.put(string2, string);
                        invertedSegments.put(string, string2);
                        CacheFolder.storeSegments(fileObject);
                    }
                    fileObjectArray[0] = bl ? fileObject.getFileObject(string2) : FileUtil.createFolder((FileObject)fileObject, (String)string2);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        return fileObjectArray[0];
    }

    private static String getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        return string;
    }

    public static synchronized FileObject getCacheFolder() {
        if (cacheFolder == null) {
            String string = CacheFolder.getNbUserDir();
            assert (string != null);
            File file = new File(string);
            File file2 = FileUtil.normalizeFile((File)new File(file, INDEX_DIR));
            if (!file2.exists()) {
                boolean bl = file2.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (file2.isDirectory() && file2.canRead() && file2.canWrite());
            cacheFolder = FileUtil.toFileObject((File)file2);
            assert (cacheFolder != null);
        }
        return cacheFolder;
    }

    public static synchronized void setCacheFolder(FileObject fileObject) {
        assert (fileObject != null && fileObject.canRead() && fileObject.canWrite());
        cacheFolder = fileObject;
        segments = null;
        invertedSegments = null;
        index = 0;
    }

    private CacheFolder() {
    }

    static {
        index = 0;
    }
}

