/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.tha.api;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class THASuspensionSupport {
    private final ExecutionEnvironment execEnv;
    private final ScheduledFuture<?> future;
    private final Listener listener;
    private final int pid;
    private volatile Status status = Status.INIT;
    private volatile State state = State.UNKNOWN;

    private THASuspensionSupport(ExecutionEnvironment executionEnvironment, int n, Listener listener, boolean bl) {
        this.execEnv = executionEnvironment;
        this.pid = n;
        this.listener = listener;
        this.state = bl ? State.RESUMED : State.SUSPENDED;
        this.future = this.startMonitor();
    }

    public static THASuspensionSupport getSupportFor(ExecutionEnvironment executionEnvironment, int n, Listener listener, boolean bl) {
        return new THASuspensionSupport(executionEnvironment, n, listener, bl);
    }

    public Status getStatus() {
        return this.status;
    }

    public State getState() {
        return this.state;
    }

    public synchronized void resume(final boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.state == State.RESUMED;
        if (this.status == Status.ENABLED && bl != bl2) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        Future future = CommonTasksSupport.sendSignal((ExecutionEnvironment)THASuspensionSupport.this.execEnv, (int)THASuspensionSupport.this.pid, (Signal)Signal.SIGUSR1, null);
                        if ((Integer)future.get() == 0) {
                            THASuspensionSupport.this.state = bl ? State.RESUMED : State.SUSPENDED;
                            THASuspensionSupport.this.listener.stateChanged(THASuspensionSupport.this.state);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            if (EventQueue.isDispatchThread()) {
                DLightExecutorService.submit((Runnable)runnable, (String)((bl ? "Resume" : "Suspend") + " THA data collection for " + this.pid + "@" + this.execEnv.toString()));
            } else {
                runnable.run();
            }
        }
    }

    private ScheduledFuture<?> startMonitor() {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
            boolean bl = hostInfo.getOSFamily() == HostInfo.OSFamily.SUNOS;
            Verifier verifier = bl ? new SolarisVerifier() : new LinuxVerifier();
            return DLightExecutorService.scheduleAtFixedRate((Runnable)verifier, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS, (String)("Monitoring process " + this.pid + "@" + this.execEnv.toString() + " for THA pause/resume readiness"));
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private synchronized void stopMonitor(Status status) {
        this.status = status;
        this.future.cancel(false);
        this.listener.statusChanged(status);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        INIT,
        ENABLED,
        DISABLED,
        ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNKNOWN,
        SUSPENDED,
        RESUMED;

    }

    public static interface Listener {
        public void statusChanged(Status var1);

        public void stateChanged(State var1);
    }

    private class SolarisVerifier
    extends Verifier {
        public SolarisVerifier() {
            this.npb.setExecutable("/bin/pargs").setArguments(new String[]{"-l", "" + THASuspensionSupport.this.pid});
            this.collectPattern = Pattern.compile(".*/collect .*");
        }
    }

    private class LinuxVerifier
    extends Verifier {
        public LinuxVerifier() {
            this.npb.setExecutable("ps").setArguments(new String[]{"-o", "comm=", "-p", "" + THASuspensionSupport.this.pid});
            this.collectPattern = Pattern.compile("^collect$");
        }
    }

    private abstract class Verifier
    implements Runnable {
        protected NativeProcessBuilder npb;
        protected Pattern collectPattern;

        public Verifier() {
            this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)THASuspensionSupport.this.execEnv);
        }

        public void run() {
            try {
                NativeProcess nativeProcess = this.npb.call();
                String string = ProcessUtils.readProcessOutputLine((Process)nativeProcess);
                int n = nativeProcess.waitFor();
                if (n != 0) {
                    THASuspensionSupport.this.stopMonitor(Status.ERROR);
                    return;
                }
                if (!this.collectPattern.matcher(string).matches()) {
                    THASuspensionSupport.this.stopMonitor(Status.ENABLED);
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

