/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.Collections;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.IdDefinedInHierarchy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class IdClassOverridesEqualsAndHashCode
extends JPAClassRule {
    public IdClassOverridesEqualsAndHashCode() {
        this.setClassContraints(Collections.singleton(JPAClassRule.ClassConstraints.IDCLASS));
    }

    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        boolean bl = false;
        boolean bl2 = false;
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            String string = executableElement.getSimpleName().toString();
            if ("equals".equals(string) && executableElement.getParameters().size() == 1) {
                if ("java.lang.Object".equals(((Object)executableElement.getParameters().get(0).asType()).toString())) {
                    bl = true;
                }
            } else if ("hashCode".equals(string) && executableElement.getParameters().size() == 0) {
                bl2 = true;
            }
            if (!bl2 || !bl) continue;
            return null;
        }
        return new ErrorDescription[]{IdClassOverridesEqualsAndHashCode.createProblem(typeElement, problemContext, NbBundle.getMessage(IdDefinedInHierarchy.class, (String)"MSG_IdClassDoesNotOverrideEquals"))};
    }
}

