/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Parser {
    private static final int OBJECT_START = 123;
    private static final int OBJECT_END = 125;
    private static final int ARRAY_START = 91;
    private static final int ARRAY_END = 93;
    private static final int COLON = 58;
    private static final int COMMA = 44;
    private static final int PLUS = 43;
    private static final int MINUS = 45;
    private static final int DOUBLE_QUOTE = 34;
    private static final int COMMENT_START = 47;
    private static final int LINE_COMMENT = 47;
    private static final int BLOCK_COMMENT = 42;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final int TRUE_START = "true".charAt(0);
    private static final int FALSE_START = "false".charAt(0);
    private static final int NULL_START = "null".charAt(0);
    private Stack<Where> where = new Stack();
    private Error error;
    private Handler handler;
    private PushbackReader reader;

    public static void parse(InputStream inputStream, Handler handler) throws IOException {
        Parser.parse(new InputStreamReader(inputStream), handler);
    }

    public static void parse(Reader reader, Handler handler) throws IOException {
        Parser parser = new Parser(reader, handler);
        parser.parse(false);
    }

    public static Iterator<Void> parseArray(InputStream inputStream, Handler handler) throws IOException {
        return Parser.parseArray(new InputStreamReader(inputStream), handler);
    }

    public static Iterator<Void> parseArray(Reader reader, Handler handler) throws IOException {
        Parser parser = new Parser(reader, handler);
        return null;
    }

    private Parser(Reader reader, Handler handler) {
        this.where.push(Where.OUT);
        this.handler = handler;
        this.reader = new PushbackReader(reader, 1);
    }

    private void parse(boolean bl) throws IOException {
        int n = 0;
        while ((n = this.reader.read()) != -1) {
            if (Character.isWhitespace(n)) continue;
            switch (this.where.peek()) {
                case OUT: {
                    if (n == 123) {
                        this.handler.objectStart();
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (n == 91) {
                        this.handler.arrayStart();
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.OBJECT_OR_ARRAY_EXPECTED;
                    break;
                }
                case COMMENT: {
                    if (n == 47) {
                        this.handleComment(true);
                        this.where.pop();
                        break;
                    }
                    if (n == 42) {
                        this.handleComment(false);
                        this.where.pop();
                        break;
                    }
                    this.error = Error.WRONG_COMMENT;
                    break;
                }
                case OBJECT: {
                    if (n == 34) {
                        String string = this.handleStringValue();
                        if (string == null) break;
                        this.handler.field(string);
                        this.where.push(Where.OBJECT_COLON);
                        break;
                    }
                    if (n == 125) {
                        this.handler.objectEnd();
                        this.where.pop();
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.FIELD_NAME_EXPECTED;
                    break;
                }
                case OBJECT_COLON: {
                    if (n == 58) {
                        this.where.pop();
                        this.where.push(Where.OBJECT_VALUE);
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COLON_EXPECTED;
                    break;
                }
                case OBJECT_VALUE: {
                    if (n == 123) {
                        this.handler.objectStart();
                        this.where.pop();
                        this.where.push(Where.OBJECT_COMMA_OR_END);
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (n == 91) {
                        this.handler.arrayStart();
                        this.where.pop();
                        this.where.push(Where.OBJECT_COMMA_OR_END);
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.handleSimpleValue(n);
                    this.where.pop();
                    this.where.push(Where.OBJECT_COMMA_OR_END);
                    break;
                }
                case OBJECT_COMMA_OR_END: {
                    if (n == 44) {
                        this.where.pop();
                        break;
                    }
                    if (n == 125) {
                        this.where.pop();
                        this.where.pop();
                        this.handler.objectEnd();
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COMMA_OR_END_OF_OBJECT_EXPECTED;
                    break;
                }
                case ARRAY: {
                    if (n == 123) {
                        this.handler.objectStart();
                        this.where.push(Where.ARRAY_COMMA_OR_END);
                        this.where.push(Where.OBJECT);
                        break;
                    }
                    if (n == 91) {
                        this.handler.arrayStart();
                        this.where.push(Where.ARRAY_COMMA_OR_END);
                        this.where.push(Where.ARRAY);
                        break;
                    }
                    if (n == 93) {
                        this.handler.arrayEnd();
                        this.where.pop();
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.handleSimpleValue(n);
                    this.where.push(Where.ARRAY_COMMA_OR_END);
                    break;
                }
                case ARRAY_COMMA_OR_END: {
                    if (n == 44) {
                        this.where.pop();
                        break;
                    }
                    if (n == 93) {
                        this.where.pop();
                        this.where.pop();
                        this.handler.arrayEnd();
                        break;
                    }
                    if (n == 47) {
                        this.where.push(Where.COMMENT);
                        break;
                    }
                    this.error = Error.COMMA_OR_END_OF_ARRAY_EXPECTED;
                }
            }
            if (this.error == null) continue;
            this.handler.error(this.error);
            break;
        }
        if (n == -1 && this.where.size() != 1) {
            this.handler.error(Error.UNCLOSED_OBJECT_OR_ARRAY);
        }
    }

    private void handleSimpleValue(int n) throws IOException {
        if (n == TRUE_START && Parser.finishString(this.reader, TRUE)) {
            this.handler.bool(true);
        } else if (n == FALSE_START && Parser.finishString(this.reader, FALSE)) {
            this.handler.bool(false);
        } else if (n == NULL_START && Parser.finishString(this.reader, NULL)) {
            this.handler.nul();
        } else if (n == 34) {
            String string = this.handleStringValue();
            if (string != null) {
                this.handler.string(string);
            }
        } else if (n == 43 || n == 45 || Parser.isDecNumber((char)n)) {
            this.reader.unread(n);
            this.handleNumberValue();
        } else {
            this.error = Error.UNKNOWN_VALUE_TYPE;
        }
    }

    private void handleNumberValue() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = -1;
        boolean bl = false;
        while ((n = this.reader.read()) != -1) {
            char c = (char)n;
            if (!(bl || c != '.' && c != 'e' && c != 'E')) {
                bl = true;
            }
            if (Parser.isFloatChar(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (c == ',' || c == ']' || c == '}' || c == '/') {
                this.reader.unread(n);
                break;
            }
            if (Character.isWhitespace(c)) break;
            this.error = Error.INVALID_NUMBER;
            return;
        }
        try {
            if (bl) {
                this.handler.number(Double.parseDouble(stringBuilder.toString()));
            } else {
                this.handler.number(Long.parseLong(stringBuilder.toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error = Error.INVALID_NUMBER;
        }
    }

    private String handleStringValue() throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        block14: while ((n = this.reader.read()) != -1) {
            switch (n) {
                case 34: {
                    return stringBuilder.toString();
                }
                case 92: {
                    n = this.reader.read();
                    switch (n) {
                        case 34: {
                            stringBuilder.append('\"');
                            continue block14;
                        }
                        case 47: {
                            stringBuilder.append('/');
                            continue block14;
                        }
                        case 98: {
                            stringBuilder.append('\b');
                            continue block14;
                        }
                        case 116: {
                            stringBuilder.append('\t');
                            continue block14;
                        }
                        case 110: {
                            stringBuilder.append('\n');
                            continue block14;
                        }
                        case 102: {
                            stringBuilder.append('\f');
                            continue block14;
                        }
                        case 114: {
                            stringBuilder.append('\r');
                            continue block14;
                        }
                        case 117: {
                            int n2 = this.handleUnicodeChar(this.reader);
                            if (n2 == -1) {
                                this.error = Error.INVALID_HEX_ENCODED_CHAR;
                                return null;
                            }
                            stringBuilder.append((char)n2);
                            continue block14;
                        }
                    }
                    this.error = Error.INVALID_ESCAPE_CHAR;
                    return null;
                }
            }
            if (!Parser.isJsonStringChar(n)) {
                this.error = Error.INVALID_CHARACTER_IN_STRING_LITERAL;
            }
            stringBuilder.append((char)n);
        }
        this.error = Error.UNCLOSED_STRING_VALUE;
        return null;
    }

    private int handleUnicodeChar(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = new char[4];
        for (int i = 0; i < 4; ++i) {
            n = reader.read();
            if (n == -1) {
                return -1;
            }
            cArray[i] = (char)n;
            if (Parser.isHexaChar(cArray[i])) continue;
            return -1;
        }
        String string = new String(cArray);
        try {
            n = Integer.parseInt(string, 16);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private void handleComment(boolean bl) throws IOException {
        int n = -1;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = this.reader.read()) != -1) {
            if (bl && (n == 10 || n == 13)) {
                this.handler.lineComment(stringBuilder.toString());
                return;
            }
            if (!bl && n == 42) {
                int n2 = this.reader.read();
                if (n2 == -1) break;
                if (n2 == 47) {
                    this.handler.comment(stringBuilder.toString());
                    return;
                }
                stringBuilder.append((char)n);
                stringBuilder.append((char)n2);
                continue;
            }
            stringBuilder.append((char)n);
        }
        this.error = Error.UNCLOSED_COMMENT;
    }

    private static boolean isFloatChar(char c) {
        return Parser.isDecNumber(c) || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E';
    }

    private static boolean isDecNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexaChar(char c) {
        char c2 = Character.toUpperCase(c);
        return Parser.isDecNumber(c) || c2 >= 'A' && c2 <= 'F';
    }

    private static boolean isJsonStringChar(int n) {
        return n == 32 || n == 33 || n >= 35 && n <= 91 || n >= 93 && n <= 0x10FFFF;
    }

    private static boolean finishString(Reader reader, String string) throws IOException {
        for (int i = 1; i < string.length(); ++i) {
            if (reader.read() == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParsingIterator
    implements Iterator<Void> {
        private ParsingIterator() {
        }

        @Override
        public boolean hasNext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Void next() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Error {
        OBJECT_OR_ARRAY_EXPECTED,
        UNKNOWN_VALUE_TYPE,
        COMMA_OR_END_OF_ARRAY_EXPECTED,
        COMMA_OR_END_OF_OBJECT_EXPECTED,
        INVALID_ESCAPE_CHAR,
        INVALID_HEX_ENCODED_CHAR,
        INVALID_CHARACTER_IN_STRING_LITERAL,
        UNCLOSED_STRING_VALUE,
        INVALID_NUMBER,
        FIELD_NAME_EXPECTED,
        COLON_EXPECTED,
        WRONG_COMMENT,
        UNCLOSED_COMMENT,
        UNCLOSED_OBJECT_OR_ARRAY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Where {
        OUT,
        OBJECT,
        OBJECT_COLON,
        OBJECT_VALUE,
        OBJECT_COMMA_OR_END,
        ARRAY,
        ARRAY_COMMA_OR_END,
        COMMENT,
        NAME;

    }

    public static interface Handler {
        public void objectStart();

        public void objectEnd();

        public void arrayStart();

        public void arrayEnd();

        public void field(String var1);

        public void bool(boolean var1);

        public void string(String var1);

        public void nul();

        public void number(long var1);

        public void number(double var1);

        public void error(Error var1);

        public void comment(String var1);

        public void lineComment(String var1);
    }
}

