/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.NbBundle;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.Util;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Registry;
import org.netbeans.modules.servicetag.ServiceTag;

public class NbServiceTagSupport2 {
    private static final String ST_DIR = "servicetag";
    private static final String ST_FILE = "servicetag";
    private static final String REG_FILE = "registration.xml";
    private static RegistrationData registration;
    private static final Logger LOG;
    private static final String REGISTRATION_HTML_NAME = "register";
    private static final String NB_HEADER_PNG_KEY = "@@NB_HEADER_PNG@@";
    private static final String PRODUCT_KEY = "@@PRODUCT@@";
    private static final String PRODUCT_TITLE_KEY = "@@PRODUCT_TITLE@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    public static String getProductName() {
        return NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.name");
    }

    public static ServiceTag createJavaFXSdkServiceTag(String string, String string2, String string3) throws IOException {
        LOG.log(Level.FINE, "Creating JavaFX SDK Standalone service tag");
        ServiceTag serviceTag = NbServiceTagSupport2.getJavaFXSdkServiceTag(string3);
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport2.newJavaFXSdkServiceTag(string, string2, string3);
            NbServiceTagSupport2.getRegistrationData(string3).addServiceTag(serviceTag);
            NbServiceTagSupport2.writeRegistrationXml(string3);
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport2.installSystemServiceTag(serviceTag, string3);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createJavaFXProductionSuiteServiceTag(String string, String string2, String string3) throws IOException {
        LOG.log(Level.FINE, "Creating JavaFX Production Suite service tag");
        ServiceTag serviceTag = NbServiceTagSupport2.getJavaFXProductionSuiteServiceTag(string3);
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport2.newJavaFXProductionSuiteServiceTag(string, string2, string3);
            NbServiceTagSupport2.getRegistrationData(string3).addServiceTag(serviceTag);
            NbServiceTagSupport2.writeRegistrationXml(string3);
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport2.installSystemServiceTag(serviceTag, string3);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegistrationXml(String string) throws IOException {
        File file = new File(string + File.separator + "servicetag" + File.separator + REG_FILE);
        File file2 = new File(string + File.separator + "servicetag");
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                NbServiceTagSupport2.getRegistrationData(string).storeToXML(bufferedOutputStream);
                bufferedOutputStream.close();
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Cannot save registration data to \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistrationData getRegistrationData(String string) throws IOException {
        if (registration != null) {
            return registration;
        }
        File file = new File(string + File.separator + "servicetag" + File.separator + REG_FILE);
        if (!file.exists()) {
            registration = new RegistrationData();
            LOG.log(Level.FINE, "Service tag file not found");
            return registration;
        }
        LOG.log(Level.FINE, "Service tag will be loaded from: " + file);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                registration = RegistrationData.loadFromXML(bufferedInputStream);
                bufferedInputStream.close();
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Bad registration data \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
        return registration;
    }

    private static ServiceTag newJavaFXSdkServiceTag(String string, String string2, String string3) throws IOException {
        String string4 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.urn");
        String string5 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.name");
        String string6 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.version");
        String string7 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.parent.urn");
        String string8 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string5, string6, string4, string8, string7, NbServiceTagSupport2.getNbProductDefinedId(string2, string6, string3), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport2.getZoneName(), string);
    }

    private static ServiceTag newJavaFXProductionSuiteServiceTag(String string, String string2, String string3) throws IOException {
        String string4 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.urn");
        String string5 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.name");
        String string6 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.version");
        String string7 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.parent.urn");
        String string8 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string5, string6, string4, string8, string7, NbServiceTagSupport2.getNbProductDefinedId(string2, string6, string3), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport2.getZoneName(), string);
    }

    private static ServiceTag getJavaFXSdkServiceTag(String string) throws IOException {
        String string2 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.urn");
        RegistrationData registrationData = NbServiceTagSupport2.getRegistrationData(string);
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string2.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getJavaFXProductionSuiteServiceTag(String string) throws IOException {
        String string2 = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.urn");
        RegistrationData registrationData = NbServiceTagSupport2.getRegistrationData(string);
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string2.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static String getNbProductDefinedId(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(string2);
        stringBuilder.append(",java.version=");
        stringBuilder.append(string);
        String string4 = ",dir=" + string3;
        if (stringBuilder.length() + string4.length() < 256) {
            stringBuilder.append(string4);
        } else {
            LOG.log(Level.INFO, "Warning: Product defined instance ID exceeds the field limit:");
        }
        return stringBuilder.toString();
    }

    private static String getZoneName() throws IOException {
        String string = "global";
        String string2 = "/usr/bin/zonename";
        File file = new File(string2);
        if (file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string2);
            Process process = processBuilder.start();
            String string3 = Util.commandOutput(process);
            if (process.exitValue() == 0) {
                string = string3.trim();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledURN(String string, String string2) throws IOException {
        File file = new File(string2 + File.separator + "servicetag" + File.separator + "servicetag");
        if (file.exists()) {
            FileReader fileReader = new FileReader(file);
            try {
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string3 = bufferedReader.readLine();
                while (string3 != null) {
                    if (string.equals(string3.trim())) {
                        String string4 = string;
                        return string4;
                    }
                    string3 = bufferedReader.readLine();
                }
                bufferedReader.close();
                String string5 = "";
                return string5;
            }
            finally {
                ((Reader)fileReader).close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSystemServiceTag(ServiceTag serviceTag, String string) throws IOException {
        if (NbServiceTagSupport2.getInstalledURN(serviceTag.getInstanceURN(), string).length() > 0) {
            LOG.log(Level.INFO, "ST is already installed ie. we have file servicetag.");
            return;
        }
        File file = new File(string + File.separator + "servicetag" + File.separator + "servicetag");
        if (Registry.isSupported()) {
            if (Registry.getSystemRegistry().getServiceTag(serviceTag.getInstanceURN()) != null) {
                LOG.log(Level.FINE, "Service tag: " + serviceTag.getInstanceURN() + " is already installed in system registry.");
                return;
            }
            Registry.getSystemRegistry().addServiceTag(serviceTag);
            FileWriter fileWriter = new FileWriter(file, true);
            try {
                LOG.log(Level.FINE, "Creating file: " + file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(serviceTag.getInstanceURN());
                bufferedWriter.newLine();
                bufferedWriter.close();
            }
            finally {
                ((Writer)fileWriter).close();
            }
        }
    }

    public static File getRegistrationHtmlPage(String string, String[] stringArray, String string2) throws IOException {
        File file = new File(string2 + File.separator + "servicetag");
        File file2 = new File(file, "register.html");
        NbServiceTagSupport2.generateRegisterHtml(file, string, stringArray, string2);
        return file2;
    }

    public static void deleteRegistrationFiles(String string) {
        File file = new File(string + File.separator + "servicetag");
        File file2 = new File(file, "servicetag");
        if (file2.exists()) {
            file2.delete();
        }
        if ((file2 = new File(file, REG_FILE)).exists()) {
            file2.delete();
        }
        if (file.isDirectory() && file.listFiles().length == 0) {
            file.delete();
        }
    }

    private static void deleteRegistrationHtmlPage(String string) {
        String string2;
        File file = new File(string + File.separator + "servicetag");
        File file2 = new File(file, (string2 = REGISTRATION_HTML_NAME) + ".html");
        if (file2.exists()) {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void generateRegisterHtml(File file, String string, String[] stringArray, String string2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        RegistrationData registrationData = NbServiceTagSupport2.getRegistrationData(string2);
        String string3 = NbConnectionSupport.getRegistrationURL(registrationData.getRegistrationURN(), string).toString();
        String string4 = "/org/netbeans/modules/reglib/resources/nb_header.png";
        File file2 = new File(string2 + File.separator + "servicetag" + File.separator + "nb_header.png");
        String string5 = file2.toURI().toURL().toString();
        InputStream inputStream = NbServiceTagSupport2.class.getResourceAsStream(string4);
        if (inputStream == null) {
            LOG.log(Level.FINE, "Missing resource file: " + string4);
        } else {
            try {
                LOG.log(Level.FINE, "Generating " + file2 + " from " + string4);
                object3 = null;
                object2 = null;
                try {
                    int n;
                    object3 = new BufferedInputStream(inputStream);
                    object2 = new FileOutputStream(file2);
                    while ((n = ((BufferedInputStream)object3).read()) != -1) {
                        ((FileOutputStream)object2).write(n);
                    }
                }
                finally {
                    object = null;
                    try {
                        if (object3 != null) {
                            ((BufferedInputStream)object3).close();
                        }
                    }
                    catch (IOException iOException) {
                        object = iOException;
                    }
                    if (object2 != null) {
                        ((FileOutputStream)object2).close();
                    }
                    if (object != null) {
                        throw object;
                    }
                }
            }
            finally {
                inputStream.close();
            }
        }
        object3 = registrationData.toString();
        object2 = System.getProperty("line.separator");
        object = ((String)object3).replaceAll("\"", "%22").replaceAll((String)object2, " ");
        String string6 = REGISTRATION_HTML_NAME;
        File file3 = new File(file, string6 + ".html");
        inputStream = null;
        Locale locale = Locale.getDefault();
        Locale[] localeArray = new Locale[]{new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()), new Locale(locale.getLanguage(), locale.getCountry()), new Locale(locale.getLanguage()), new Locale("")};
        for (Locale object4 : localeArray) {
            string4 = "/org/netbeans/modules/reglib/resources/register" + (object4.toString().equals("") ? "" : "_" + object4) + ".html";
            LOG.log(Level.FINE, "Looking for html in: " + string4);
            inputStream = NbServiceTagSupport2.class.getResourceAsStream(string4);
            if (inputStream != null) break;
        }
        if (inputStream != null) {
            try {
                LOG.log(Level.FINE, "Found html in: " + string4);
                LOG.log(Level.FINE, "Generating " + file3);
                Object object5 = null;
                PrintWriter printWriter = null;
                try {
                    void var20_30;
                    object5 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    printWriter = new PrintWriter(file3, "UTF-8");
                    String string7 = null;
                    String string8 = "";
                    String string9 = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        void var20_32;
                        if (i > 0) {
                            String string10 = (String)var20_30 + " " + NbBundle.getMessage(NbServiceTagSupport2.class, "MSG_junction") + " ";
                            string9 = string9 + " " + NbBundle.getMessage(NbServiceTagSupport2.class, "MSG_junction") + " ";
                        }
                        String string11 = (String)var20_32 + "<strong>" + stringArray[i] + "</strong>";
                        string9 = string9 + stringArray[i];
                    }
                    while ((string7 = ((BufferedReader)object5).readLine()) != null) {
                        String string12 = string7;
                        if (string7.contains(PRODUCT_KEY)) {
                            string12 = string7.replace(PRODUCT_KEY, (CharSequence)var20_30);
                        } else if (string7.contains(PRODUCT_TITLE_KEY)) {
                            string12 = string7.replace(PRODUCT_TITLE_KEY, string9);
                        } else if (string7.contains(NB_HEADER_PNG_KEY)) {
                            string12 = string7.replace(NB_HEADER_PNG_KEY, string5);
                        } else if (string7.contains(REGISTRATION_URL_KEY)) {
                            string12 = string7.replace(REGISTRATION_URL_KEY, string3);
                        } else if (string7.contains(REGISTRATION_PAYLOAD_KEY)) {
                            string12 = string7.replace(REGISTRATION_PAYLOAD_KEY, (CharSequence)object);
                        }
                        printWriter.println(string12);
                    }
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (object5 != null) {
                        ((BufferedReader)object5).close();
                    }
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.reglib.NbServiceTagSupport2");
    }
}

