/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DtraceDataAndStackParser
extends DtraceParser {
    private static final boolean TRACE = Boolean.getBoolean("dlight.dns.parser.trace");
    private static PrintStream traceStream;
    private State state;
    private List<String> currData;
    private long currSampleDuration;
    private List<CharSequence> currStack = new ArrayList<CharSequence>(32);
    private List<String> colNames;
    private int colCount;
    private final boolean isProfiler;
    private StackDataStorage sds;

    public DtraceDataAndStackParser(DataTableMetadata dataTableMetadata) {
        this(dataTableMetadata, null);
    }

    DtraceDataAndStackParser(DataTableMetadata dataTableMetadata, StackDataStorage stackDataStorage) {
        super(dataTableMetadata);
        this.sds = stackDataStorage;
        this.state = State.WAITING_DATA;
        this.colNames = new ArrayList<String>(dataTableMetadata.getColumnsCount());
        for (DataTableMetadata.Column column : dataTableMetadata.getColumns()) {
            this.colNames.add(column.getColumnName());
        }
        this.colCount = dataTableMetadata.getColumnsCount();
        this.isProfiler = dataTableMetadata.getName().equals("CallStack");
    }

    void setStackDataStorage(StackDataStorage stackDataStorage) {
        this.sds = stackDataStorage;
    }

    protected List<String> processDataLine(String string) {
        return super.parse(string, this.colCount - 1);
    }

    @Override
    public DataRow process(String string) {
        if (TRACE) {
            traceStream.print(string);
            traceStream.print('\t');
            traceStream.println("" + (Object)((Object)this.state));
        }
        switch (this.state) {
            case WAITING_DATA: {
                if (string.length() == 0) {
                    return null;
                }
                DLightLogger.assertTrue((boolean)this.currStack.isEmpty());
                DLightLogger.assertFalse((boolean)Character.isWhitespace(string.charAt(0)), (String)"Data row shouldn't start with ' '");
                this.currData = this.processDataLine(string);
                if (this.isProfiler) {
                    try {
                        this.currSampleDuration = Long.parseLong(this.currData.get(this.colCount - 2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        DLightLogger.instance.log(Level.WARNING, "error parsing line " + string, numberFormatException);
                    }
                }
                this.state = State.IN_STACK;
                return null;
            }
            case IN_STACK: {
                if (string.length() > 0) {
                    string = string.trim();
                    if (this.isProfiler || !string.startsWith("libc.so.")) {
                        this.currStack.add(string);
                    }
                    return null;
                }
                Collections.reverse(this.currStack);
                long l = this.sds == null ? -1L : this.sds.putSample(this.currStack, DataUtil.toLong((Object)this.currData.get(0)), this.currSampleDuration);
                this.currStack.clear();
                this.state = State.WAITING_DATA;
                this.currData.add(Long.toString(l));
                return new DataRow(this.colNames, this.currData);
            }
        }
        return null;
    }

    static {
        if (TRACE) {
            String string = null;
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                string = hostInfo.getTempDir();
            }
            catch (IOException iOException) {
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
            if (string == null) {
                string = System.getProperty("java.io.tmpdir");
            }
            try {
                traceStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(string + "/dsp.log"), 32768));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                traceStream = System.err;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WAITING_DATA,
        IN_STACK;

    }
}

