/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.StepActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.StepRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;

public class StepIntoNextMethod
implements Executor,
PropertyChangeListener {
    private static final Logger smartLogger = Logger.getLogger("org.netbeans.modules.debugger.jpda.smartstepping");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.jdievents");
    private volatile StepRequest stepIntoRequest;
    private String position;
    private int depth;
    private JPDADebuggerImpl debugger;
    private ContextProvider contextProvider;
    private boolean smartSteppingStepOut;
    private Properties p;
    private StepActionProvider stepActionProvider;
    private SmartSteppingFilter smartSteppingFilter;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    public StepIntoNextMethod(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.contextProvider = contextProvider;
        this.getSmartSteppingFilterImpl().addPropertyChangeListener((PropertyChangeListener)this);
        SourcePath sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        sourcePath.addPropertyChangeListener(this);
        Map map = (Map)contextProvider.lookupFirst(null, Map.class);
        if (map != null) {
            this.smartSteppingStepOut = map.containsKey("SS_ACTION_STEPOUT");
        }
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    private final JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    public void runAction() {
        this.runAction(true);
    }

    public void runAction(boolean bl) {
        this.runAction(null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object object, boolean bl) {
        smartLogger.finer("STEP INTO NEXT METHOD.");
        JPDAThread jPDAThread = this.getDebuggerImpl().getCurrentThread();
        if (jPDAThread == null) {
            smartLogger.finer("Can not step into next method! No current thread!");
            return;
        }
        Lock lock = this.getDebuggerImpl().getSuspend() == 1 ? ((JPDAThreadImpl)jPDAThread).accessLock.writeLock() : this.getDebuggerImpl().accessLock.writeLock();
        lock.lock();
        try {
            if (!jPDAThread.isSuspended() && !((JPDAThreadImpl)jPDAThread).isSuspendedNoFire()) {
                if (smartLogger.isLoggable(Level.FINER)) {
                    smartLogger.finer("Can not step into next method! Thread " + jPDAThread + " not suspended!");
                }
                return;
            }
            JPDAThreadImpl[] jPDAThreadImplArray = new JPDAThreadImpl[]{null};
            int n = ActionsManager.ACTION_STEP_OUT.equals(object) ? 3 : 1;
            StepRequest stepRequest = this.setStepRequest(n, jPDAThreadImplArray);
            this.position = jPDAThread.getClassName() + '.' + jPDAThread.getMethodName() + ':' + jPDAThread.getLineNumber(null);
            if (n == 1) {
                this.stepIntoRequest = stepRequest;
            }
            this.depth = jPDAThread.getStackDepth();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JDI Request (action step into next method): " + stepRequest);
            }
            if (stepRequest == null) {
                return;
            }
            ((JPDAThreadImpl)jPDAThread).setInStep(true, stepRequest);
            if (bl) {
                if (jPDAThreadImplArray[0] == null) {
                    this.getDebuggerImpl().resume();
                } else {
                    this.getDebuggerImpl().resumeCurrentThread();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "exclusionPatterns") {
            if (propertyChangeEvent.getOldValue() != null) {
                smartLogger.finer("Exclusion patterns removed. Removing step requests.");
                JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
                if (jPDAThreadImpl != null) {
                    ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                    this.removeStepRequests(threadReference);
                }
            } else {
                if (smartLogger.isLoggable(Level.FINER)) {
                    if (this.stepIntoRequest == null) {
                        smartLogger.finer("Exclusion patterns has been added");
                    } else {
                        smartLogger.finer("Add exclusion patterns: " + propertyChangeEvent.getNewValue());
                    }
                }
                try {
                    this.addPatternsToRequest(((Set)propertyChangeEvent.getNewValue()).toArray(new String[((Set)propertyChangeEvent.getNewValue()).size()]), this.stepIntoRequest);
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                    return;
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
            }
        } else if (propertyChangeEvent.getPropertyName() == "sourceRoots") {
            smartLogger.finer("Source roots changed");
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (jPDAThreadImpl != null) {
                ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                this.removeStepRequests(threadReference);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean exec(Event var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removed(EventRequest eventRequest) {
        StepRequest stepRequest = (StepRequest)eventRequest;
        try {
            JPDAThreadImpl jPDAThreadImpl = this.getDebuggerImpl().getThread(StepRequestWrapper.thread(stepRequest));
            jPDAThreadImpl.setInStep(false, null);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
    }

    private StepActionProvider getStepActionProvider() {
        if (this.stepActionProvider == null) {
            List list = this.contextProvider.lookup(null, ActionsProvider.class);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (!(list.get(i) instanceof StepActionProvider)) continue;
                this.stepActionProvider = (StepActionProvider)list.get(i);
            }
        }
        return this.stepActionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStepRequests(ThreadReference threadReference) {
        StepIntoNextMethod stepIntoNextMethod = this;
        synchronized (stepIntoNextMethod) {
            this.stepIntoRequest = null;
        }
        JPDADebuggerActionProvider.removeStepRequests(this.getDebuggerImpl(), threadReference);
        smartLogger.finer("removing all patterns, all step requests.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StepRequest setStepRequest(int n) {
        StepRequest stepRequest = null;
        if (n == 1) {
            StepIntoNextMethod stepIntoNextMethod = this;
            synchronized (stepIntoNextMethod) {
                if (this.stepIntoRequest != null) {
                    try {
                        try {
                            EventRequestWrapper.enable(this.stepIntoRequest);
                            stepRequest = this.stepIntoRequest;
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                            this.stepIntoRequest = null;
                            return null;
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                            this.getDebuggerImpl().getOperator().unregister(this.stepIntoRequest);
                            this.stepIntoRequest = null;
                            return null;
                        }
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                        this.stepIntoRequest = null;
                        return null;
                    }
                }
            }
        }
        if (stepRequest != null) {
            return stepRequest;
        }
        return this.setStepRequest(n, null);
    }

    private StepRequest setStepRequest(int n, JPDAThreadImpl[] jPDAThreadImplArray) {
        int n2;
        StepRequest stepRequest;
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        this.removeStepRequests(threadReference);
        VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
        if (virtualMachine == null) {
            return null;
        }
        try {
            stepRequest = EventRequestManagerWrapper.createStepRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), threadReference, -2, n);
            this.getDebuggerImpl().getOperator().register(stepRequest, this);
            n2 = this.getDebuggerImpl().getSuspend();
            EventRequestWrapper.setSuspendPolicy(stepRequest, n2);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (smartLogger.isLoggable(Level.FINER)) {
            smartLogger.finer("Set step request(" + n + ") and patterns: ");
        }
        try {
            try {
                this.addPatternsToRequest(this.getSmartSteppingFilterImpl().getExclusionPatterns(), stepRequest);
                EventRequestWrapper.enable(stepRequest);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                stepRequest = null;
                return null;
            }
            catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                stepRequest = null;
                return null;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return null;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return null;
        }
        if (jPDAThreadImplArray != null) {
            jPDAThreadImplArray[0] = n2 == 1 ? jPDAThreadImpl : null;
        }
        return stepRequest;
    }

    private SmartSteppingFilter getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilter == null) {
            this.smartSteppingFilter = (SmartSteppingFilter)this.contextProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilter;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.contextProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }

    private void addPatternsToRequest(String[] stringArray, StepRequest stepRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (stepRequest == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                StepRequestWrapper.addClassExclusionFilter(stepRequest, stringArray[i]);
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
                return;
            }
            smartLogger.finer("   add pattern: " + stringArray[i]);
        }
    }

    private boolean isFilteredClassOnStack(ThreadReference threadReference, int n) {
        String[] stringArray = this.getSmartSteppingFilterImpl().getExclusionPatterns();
        if (stringArray.length == 0) {
            return false;
        }
        try {
            int n2 = ThreadReferenceWrapper.frameCount(threadReference);
            if (n2 <= n) {
                return false;
            }
            List<StackFrame> list = ThreadReferenceWrapper.frames(threadReference, 0, n2 - n);
            for (StackFrame stackFrame : list) {
                String string = ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(stackFrame)));
                for (String string2 : stringArray) {
                    if (!string.contentEquals(string2)) continue;
                    smartLogger.finer(" class '" + string + "' on stack.");
                    return true;
                }
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            // empty catch block
        }
        return false;
    }
}

