/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.management.MethodCache;
import org.jruby.nb.util.collections.WeakHashSet;

public class CacheMap {
    private final AtomicInteger addCount = new AtomicInteger(0);
    private final AtomicInteger removeCount = new AtomicInteger(0);
    private final AtomicInteger moduleIncludeCount = new AtomicInteger(0);
    private final AtomicInteger moduleTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushCount = new AtomicInteger(0);
    private final Map<DynamicMethod, Set<CacheSite>> mappings = new WeakHashMap<DynamicMethod, Set<CacheSite>>();

    public CacheMap(Ruby ruby) {
        ruby.getBeanManager().register(new MethodCache(this));
    }

    public int getAddCount() {
        return this.addCount.get();
    }

    public int getRemoveCount() {
        return this.removeCount.get();
    }

    public int getModuleIncludeCount() {
        return this.moduleIncludeCount.get();
    }

    public int getModuleTriggeredRemoveCount() {
        return this.moduleTriggeredRemoveCount.get();
    }

    public int getFlushCount() {
        return this.flushCount.get();
    }

    public synchronized void flush() {
        int n = 0;
        for (DynamicMethod dynamicMethod : this.mappings.keySet()) {
            Set<CacheSite> set = this.mappings.get(dynamicMethod);
            if (set == null) continue;
            for (CacheSite cacheSite : set) {
                ++n;
                cacheSite.removeCachedMethod();
            }
        }
        this.mappings.clear();
        this.flushTriggeredRemoveCount.addAndGet(n);
        this.removeCount.addAndGet(n);
        this.flushCount.incrementAndGet();
    }

    public synchronized void add(DynamicMethod dynamicMethod, CacheSite cacheSite) {
        Set<CacheSite> set = this.mappings.get(dynamicMethod);
        if (set == null) {
            set = new WeakHashSet<CacheSite>();
            this.mappings.put(dynamicMethod, set);
        }
        set.add(cacheSite);
        this.addCount.incrementAndGet();
    }

    public synchronized void remove(DynamicMethod dynamicMethod) {
        Set<CacheSite> set = this.mappings.remove(dynamicMethod);
        if (set == null) {
            return;
        }
        for (CacheSite cacheSite : set) {
            if (cacheSite == null) continue;
            cacheSite.removeCachedMethod();
        }
        this.removeCount.incrementAndGet();
    }

    public synchronized void moduleIncluded(RubyModule rubyModule, RubyModule rubyModule2) {
        int n = 0;
        for (String string : rubyModule2.getMethods().keySet()) {
            for (RubyModule rubyModule3 = rubyModule; rubyModule3 != null; rubyModule3 = rubyModule3.getSuperClass()) {
                Set<CacheSite> set;
                DynamicMethod dynamicMethod;
                if (rubyModule3 == rubyModule2 || (dynamicMethod = rubyModule3.getMethods().get(string)) == null || (set = this.mappings.remove(dynamicMethod)) == null) continue;
                for (CacheSite cacheSite : set) {
                    ++n;
                    cacheSite.removeCachedMethod();
                }
            }
        }
        this.moduleTriggeredRemoveCount.addAndGet(n);
        this.removeCount.addAndGet(n);
        this.moduleIncludeCount.incrementAndGet();
    }

    public static interface CacheSite {
        public void removeCachedMethod();
    }
}

